/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.templateengine.blocks;

import com.microsoft.semantickernel.orchestration.ContextVariables;
import com.microsoft.semantickernel.templateengine.TemplateException;
import com.microsoft.semantickernel.templateengine.blocks.Block;
import com.microsoft.semantickernel.templateengine.blocks.BlockTypes;
import com.microsoft.semantickernel.templateengine.blocks.TextRendering;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VarBlock
extends Block
implements TextRendering {
    private static final Logger LOGGER = LoggerFactory.getLogger(VarBlock.class);
    private final String name;

    public VarBlock(String content) {
        super(content, BlockTypes.Variable);
        if (content.length() < 2) {
            LOGGER.error("The variable name is empty");
        }
        this.name = content.substring(1);
    }

    @Override
    public String render(ContextVariables variables) {
        if (variables == null) {
            return "";
        }
        if (this.name == null || this.name.isEmpty()) {
            throw new TemplateException(TemplateException.ErrorCodes.SYNTAX_ERROR, "Variable rendering failed, the variable name is empty");
        }
        String value = (String)variables.asMap().get(this.name);
        if (value == null) {
            LOGGER.warn("Variable `{}{}` not found", (Object)Character.valueOf('$'), (Object)this.name);
        }
        return value != null ? value : "";
    }

    public boolean isValid() {
        if (this.getContent() == null || this.getContent().isEmpty()) {
            LOGGER.error("A variable must start with the symbol {} and have a name", (Object)Character.valueOf('$'));
            return false;
        }
        if (this.getContent().charAt(0) != '$') {
            LOGGER.error("A variable must start with the symbol {}", (Object)Character.valueOf('$'));
            return false;
        }
        if (this.getContent().length() < 2) {
            LOGGER.error("The variable name is empty");
            return false;
        }
        if (!this.name.matches("^[a-zA-Z0-9_]*$")) {
            LOGGER.error("The variable name '{}' contains invalid characters. Only alphanumeric chars and underscore are allowed.", (Object)this.name);
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }
}

