/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.templateengine.blocks;

import com.microsoft.semantickernel.orchestration.ContextVariables;
import com.microsoft.semantickernel.templateengine.blocks.Block;
import com.microsoft.semantickernel.templateengine.blocks.BlockTypes;
import com.microsoft.semantickernel.templateengine.blocks.TextRendering;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.util.annotation.Nullable;

public final class ValBlock
extends Block
implements TextRendering {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValBlock.class);
    private char first = '\u0000';
    private char last = '\u0000';
    private String value = "";

    public ValBlock(String quotedValue) {
        super(quotedValue.trim(), BlockTypes.Value);
        if (this.getContent().length() < 2) {
            LOGGER.error("A value must have single quotes or double quotes on both sides");
            return;
        }
        this.first = this.getContent().charAt(0);
        this.last = this.getContent().charAt(this.getContent().length() - 1);
        this.value = this.getContent().substring(1, this.getContent().length() - 2);
    }

    @Override
    @Nullable
    public String render(ContextVariables variables) {
        return this.value;
    }

    public boolean isValid() {
        if (this.getContent().length() < 2) {
            LOGGER.error("A value must have single quotes or double quotes on both sides");
            return false;
        }
        if (this.first != this.last) {
            LOGGER.error("A value must be defined using either single quotes or double quotes, not both");
            return false;
        }
        return true;
    }

    public static boolean hasValPrefix(@Nullable String text) {
        return text != null && text.length() > 0 && (text.charAt(0) == '\"' || text.charAt(0) == '\'');
    }
}

