/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.templateengine.blocks;

import com.microsoft.semantickernel.orchestration.ContextVariables;
import com.microsoft.semantickernel.orchestration.SKContext;
import com.microsoft.semantickernel.orchestration.SKFunction;
import com.microsoft.semantickernel.skilldefinition.ReadOnlyFunctionCollection;
import com.microsoft.semantickernel.skilldefinition.ReadOnlySkillCollection;
import com.microsoft.semantickernel.templateengine.TemplateException;
import com.microsoft.semantickernel.templateengine.blocks.Block;
import com.microsoft.semantickernel.templateengine.blocks.BlockTypes;
import com.microsoft.semantickernel.templateengine.blocks.CodeRendering;
import com.microsoft.semantickernel.templateengine.blocks.FunctionIdBlock;
import com.microsoft.semantickernel.templateengine.blocks.TextRendering;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public final class CodeBlock
extends Block
implements CodeRendering {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeBlock.class);
    private final List<Block> tokens;

    public CodeBlock(List<Block> tokens, String content) {
        super(content, BlockTypes.Code);
        this.tokens = Collections.unmodifiableList(tokens);
    }

    public boolean isValid() {
        Optional<Block> invalid = this.tokens.stream().filter(token -> !token.isValid()).findFirst();
        if (invalid.isPresent()) {
            LOGGER.error("Invalid block" + invalid.get().getContent());
            return false;
        }
        if (this.tokens.size() > 1) {
            if (this.tokens.get(0).getType() != BlockTypes.FunctionId) {
                LOGGER.error("Unexpected second token found: " + this.tokens.get(1).getContent());
                return false;
            }
            if (this.tokens.get(1).getType() != BlockTypes.Value && this.tokens.get(1).getType() != BlockTypes.Variable) {
                LOGGER.error("Functions support only one parameter");
                return false;
            }
        }
        if (this.tokens.size() > 2) {
            LOGGER.error("Unexpected second token found: " + this.tokens.get(1).getContent());
            return false;
        }
        return true;
    }

    @Override
    public Mono<String> renderCodeAsync(SKContext context) {
        if (!this.isValid()) {
            throw new TemplateException(TemplateException.ErrorCodes.SYNTAX_ERROR);
        }
        switch (this.tokens.get(0).getType()) {
            case Value: 
            case Variable: {
                return Mono.just((Object)((TextRendering)this.tokens.get(0)).render(context.getVariables()));
            }
            case FunctionId: {
                return this.renderFunctionCallAsync((FunctionIdBlock)this.tokens.get(0), context);
            }
        }
        throw new RuntimeException("Unknown type");
    }

    private Mono<String> renderFunctionCallAsync(FunctionIdBlock fBlock, SKContext context) {
        SKFunction function = this.getFunctionFromSkillCollection(context.getSkills(), fBlock);
        if (function == null) {
            throw new RuntimeException("Function not found");
        }
        ContextVariables variables = context.getVariables();
        if (this.tokens.size() > 1) {
            String content = this.tokens.get(1).getContent();
            String input = ((TextRendering)this.tokens.get(1)).render(variables);
            if (content.startsWith("$")) {
                String varName = content.substring(1);
                variables = variables.writableClone().setVariable(varName, input);
            } else {
                variables = variables.writableClone().update(input);
            }
        }
        Mono result = function.invokeWithCustomInputAsync(variables, context.getSemanticMemory(), context.getSkills());
        return result.map(it -> it.getResult());
    }

    @Nullable
    private SKFunction getFunctionFromSkillCollection(ReadOnlySkillCollection skills, FunctionIdBlock fBlock) {
        ReadOnlyFunctionCollection skill;
        String skillName = fBlock.getSkillName();
        if ((skillName == null || skillName.isEmpty()) && skills.hasFunction(fBlock.getFunctionName())) {
            SKFunction function = skills.getFunction(fBlock.getFunctionName(), SKFunction.class);
            return function;
        }
        if (skillName != null && !skillName.isEmpty() && (skill = skills.getFunctions(fBlock.getSkillName())) != null) {
            return skill.getFunction(fBlock.getFunctionName());
        }
        return null;
    }
}

