/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.templateengine;

import com.microsoft.semantickernel.SKException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TemplateException
extends SKException {
    @Nonnull
    private final ErrorCodes errorCode;

    public TemplateException(@Nonnull ErrorCodes error) {
        this(error, null, null);
    }

    public TemplateException(@Nonnull ErrorCodes errorCode, @Nullable String message) {
        this(errorCode, message, null);
    }

    public TemplateException(@Nonnull ErrorCodes errorCode, @Nullable String message, @Nullable Throwable innerException) {
        super(TemplateException.formatDefaultMessage((String)errorCode.getMessage(), (String)message), innerException);
        this.errorCode = errorCode;
    }

    public ErrorCodes getErrorCode() {
        return this.errorCode;
    }

    private static String getDefaultMessage(@Nonnull ErrorCodes errorCode, @Nullable String message) {
        return String.format("%s: %s", errorCode.getMessage(), message);
    }

    public static enum ErrorCodes {
        UNKNOWN_ERROR("Unknown error"),
        SYNTAX_ERROR("Syntax error, the template syntax used is not valid"),
        UNEXPECTED_BLOCK_TYPE("The block type produced be the tokenizer was not expected"),
        FUNCTION_NOT_FOUND("The template requires an unknown function"),
        RUNTIME_ERROR("The template execution failed, e.g. a function call threw an exception");

        private final String message;

        private ErrorCodes(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

