/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.templateengine;

import com.microsoft.semantickernel.orchestration.SKContext;
import com.microsoft.semantickernel.templateengine.PromptTemplateEngine;
import com.microsoft.semantickernel.templateengine.TemplateException;
import com.microsoft.semantickernel.templateengine.TemplateTokenizer;
import com.microsoft.semantickernel.templateengine.blocks.Block;
import com.microsoft.semantickernel.templateengine.blocks.CodeRendering;
import com.microsoft.semantickernel.templateengine.blocks.TextRendering;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultPromptTemplateEngine
implements PromptTemplateEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPromptTemplateEngine.class);
    private final TemplateTokenizer tokenizer = new TemplateTokenizer();

    public List<Block> extractBlocks(String templateText) {
        return this.extractBlocks(templateText, true);
    }

    public List<Block> extractBlocks(String templateText, boolean validate) {
        List<Block> blocks = this.tokenizer.tokenize(templateText);
        if (validate) {
            blocks.forEach(block -> {
                if (!block.isValid()) {
                    throw new TemplateException(TemplateException.ErrorCodes.SYNTAX_ERROR);
                }
            });
        }
        return blocks;
    }

    public Mono<String> renderAsync(String templateText, SKContext context) {
        List<Block> blocks = this.extractBlocks(templateText);
        return this.renderAsync(blocks, context);
    }

    public Mono<String> renderAsync(List<Block> blocks, SKContext context) {
        return Flux.fromIterable(blocks).concatMap(block -> {
            if (block instanceof TextRendering) {
                return Mono.just((Object)((TextRendering)block).render(context.getVariables()));
            }
            if (block instanceof CodeRendering) {
                return ((CodeRendering)block).renderCodeAsync(context);
            }
            String message = "Unexpected block type, the block doesn't have a rendering method";
            LOGGER.error(message);
            return Mono.error((Throwable)((Object)new TemplateException(TemplateException.ErrorCodes.UNEXPECTED_BLOCK_TYPE, message)));
        }).collectList().map(values -> {
            StringBuilder sb = new StringBuilder();
            values.forEach(sb::append);
            return sb.toString();
        });
    }

    public static final class Builder
    implements PromptTemplateEngine.Builder {
        public PromptTemplateEngine build() {
            return new DefaultPromptTemplateEngine();
        }
    }
}

