/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.templateengine;

import com.microsoft.semantickernel.templateengine.TemplateException;
import com.microsoft.semantickernel.templateengine.blocks.Block;
import com.microsoft.semantickernel.templateengine.blocks.FunctionIdBlock;
import com.microsoft.semantickernel.templateengine.blocks.ValBlock;
import com.microsoft.semantickernel.templateengine.blocks.VarBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CodeTokenizer {
    public List<Block> tokenize(String text) {
        if (text == null) {
            return new ArrayList<Block>();
        }
        if ((text = text.trim()).isEmpty()) {
            return Collections.unmodifiableList(new ArrayList());
        }
        TokenTypes currentTokenType = TokenTypes.None;
        StringBuilder currentTokenContent = new StringBuilder();
        char textValueDelimiter = '\u0000';
        ArrayList<Block> blocks = new ArrayList<Block>();
        char nextChar = text.charAt(0);
        boolean spaceSeparatorFound = false;
        if (text.length() == 1) {
            switch (nextChar) {
                case '$': {
                    blocks.add(new VarBlock(text));
                    break;
                }
                case '\"': 
                case '\'': {
                    blocks.add(new ValBlock(text));
                    break;
                }
                default: {
                    blocks.add(new FunctionIdBlock(text));
                }
            }
            return blocks;
        }
        boolean skipNextChar = false;
        for (int nextCharCursor = 1; nextCharCursor < text.length(); ++nextCharCursor) {
            char currentChar = nextChar;
            nextChar = text.charAt(nextCharCursor);
            if (skipNextChar) {
                skipNextChar = false;
                continue;
            }
            if (nextCharCursor == 1) {
                if (CodeTokenizer.isVarPrefix(currentChar)) {
                    currentTokenType = TokenTypes.Variable;
                } else if (CodeTokenizer.isQuote(currentChar)) {
                    currentTokenType = TokenTypes.Value;
                    textValueDelimiter = currentChar;
                } else {
                    currentTokenType = TokenTypes.FunctionId;
                }
                currentTokenContent.append(currentChar);
                continue;
            }
            if (currentTokenType == TokenTypes.Value) {
                if (currentChar == '\\' && CodeTokenizer.CanBeEscaped(nextChar)) {
                    currentTokenContent.append(nextChar);
                    skipNextChar = true;
                    continue;
                }
                currentTokenContent.append(currentChar);
                if (currentChar != textValueDelimiter) continue;
                blocks.add(new ValBlock(currentTokenContent.toString()));
                currentTokenContent = new StringBuilder();
                currentTokenType = TokenTypes.None;
                spaceSeparatorFound = false;
                continue;
            }
            if (CodeTokenizer.IsBlankSpace(currentChar)) {
                if (currentTokenType == TokenTypes.Variable) {
                    blocks.add(new VarBlock(currentTokenContent.toString()));
                    currentTokenContent = new StringBuilder();
                } else if (currentTokenType == TokenTypes.FunctionId) {
                    blocks.add(new FunctionIdBlock(currentTokenContent.toString()));
                    currentTokenContent = new StringBuilder();
                }
                spaceSeparatorFound = true;
                currentTokenType = TokenTypes.None;
                continue;
            }
            currentTokenContent.append(currentChar);
            if (currentTokenType != TokenTypes.None) continue;
            if (!spaceSeparatorFound) {
                throw new TemplateException(TemplateException.ErrorCodes.SYNTAX_ERROR, "Tokens must be separated by one space least");
            }
            if (CodeTokenizer.isQuote(currentChar)) {
                currentTokenType = TokenTypes.Value;
                textValueDelimiter = currentChar;
                continue;
            }
            currentTokenType = CodeTokenizer.isVarPrefix(currentChar) ? TokenTypes.Variable : TokenTypes.FunctionId;
        }
        currentTokenContent.append(nextChar);
        switch (currentTokenType) {
            case Value: {
                blocks.add(new ValBlock(currentTokenContent.toString()));
                break;
            }
            case Variable: {
                blocks.add(new VarBlock(currentTokenContent.toString()));
                break;
            }
            case FunctionId: {
                blocks.add(new FunctionIdBlock(currentTokenContent.toString()));
                break;
            }
            case None: {
                throw new TemplateException(TemplateException.ErrorCodes.SYNTAX_ERROR, "Tokens must be separated by one space least");
            }
        }
        return blocks;
    }

    private static boolean isVarPrefix(char c) {
        return c == '$';
    }

    private static boolean IsBlankSpace(char c) {
        return Character.isWhitespace(c);
    }

    private static boolean isQuote(char c) {
        return c == '\"' || c == '\'';
    }

    private static boolean CanBeEscaped(char c) {
        return c == '\"' || c == '\'' || c == '\\';
    }

    private static enum TokenTypes {
        None(0),
        Value(1),
        Variable(2),
        FunctionId(3);


        private TokenTypes(int i) {
        }
    }
}

