/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.skilldefinition;

import com.microsoft.semantickernel.exceptions.SkillsNotFoundException;
import com.microsoft.semantickernel.orchestration.SKFunction;
import com.microsoft.semantickernel.skilldefinition.CaseInsensitiveMap;
import com.microsoft.semantickernel.skilldefinition.FunctionNotFound;
import com.microsoft.semantickernel.skilldefinition.ReadOnlyFunctionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public class FunctionCollection
implements ReadOnlyFunctionCollection {
    private final CaseInsensitiveMap<SKFunction<?>> functionCollection;
    private final String skillName;

    private FunctionCollection(String skillName, Map<String, SKFunction<?>> functionCollection) {
        this.functionCollection = new CaseInsensitiveMap(functionCollection);
        this.skillName = skillName;
    }

    public FunctionCollection(String skillName, List<? extends SKFunction<?>> functionCollection) {
        this(skillName, functionCollection.stream().collect(Collectors.toMap(it -> it.getName().toLowerCase(Locale.ROOT), it -> it)));
    }

    public FunctionCollection(String skillName) {
        this.skillName = skillName;
        this.functionCollection = new CaseInsensitiveMap();
    }

    public FunctionCollection(ReadOnlyFunctionCollection value) {
        this.skillName = value.getSkillName();
        this.functionCollection = new CaseInsensitiveMap<SKFunction>(Collections.unmodifiableMap(value.getAll().stream().collect(Collectors.toMap(SKFunction::getName, it -> it))));
    }

    public String getSkillName() {
        return this.skillName;
    }

    public SKFunction<?> getFunction(String functionName) {
        SKFunction<?> func = this.functionCollection.get(functionName.toLowerCase(Locale.ROOT));
        if (func == null) {
            throw new FunctionNotFound(FunctionNotFound.ErrorCodes.FUNCTION_NOT_FOUND, functionName);
        }
        return func;
    }

    public <T extends SKFunction> T getFunction(String functionName, @Nullable Class<T> clazz) {
        SKFunction<?> func = this.getFunction(functionName);
        if (clazz == null) {
            return (T)func;
        }
        if (clazz.isInstance(func)) {
            return (T)func;
        }
        throw new SkillsNotFoundException(SkillsNotFoundException.ErrorCodes.SKILLS_NOT_FOUND, "Incorrect type requested, expected type of " + clazz.getName() + " found class of type " + func.getClass().getName());
    }

    @CheckReturnValue
    public FunctionCollection copy() {
        return new FunctionCollection(this.skillName, this.functionCollection);
    }

    public List<SKFunction<?>> getAll() {
        return Collections.unmodifiableList(new ArrayList(this.functionCollection.values()));
    }

    public FunctionCollection put(String functionName, SKFunction<?> functionInstance) {
        this.functionCollection.put(functionName.toLowerCase(Locale.ROOT), functionInstance);
        return this;
    }

    public FunctionCollection merge(FunctionCollection value) {
        this.functionCollection.putAll((Map<String, SKFunction<?>>)value.functionCollection);
        return this;
    }
}

