/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.skilldefinition;

import com.microsoft.semantickernel.orchestration.SKFunction;
import com.microsoft.semantickernel.skilldefinition.CaseInsensitiveMap;
import com.microsoft.semantickernel.skilldefinition.FunctionCollection;
import com.microsoft.semantickernel.skilldefinition.ReadOnlyFunctionCollection;
import com.microsoft.semantickernel.skilldefinition.ReadOnlySkillCollection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public class DefaultSkillCollection
implements ReadOnlySkillCollection {
    private final CaseInsensitiveMap<FunctionCollection> skillCollection;

    protected Map<String, FunctionCollection> getSkillCollection() {
        return this.skillCollection;
    }

    public DefaultSkillCollection(ReadOnlySkillCollection skillCollection) {
        this(skillCollection.asMap());
    }

    public DefaultSkillCollection(Map<String, ? extends ReadOnlyFunctionCollection> skillCollection) {
        Map<String, FunctionCollection> cloned = skillCollection.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, it -> new FunctionCollection((ReadOnlyFunctionCollection)it.getValue())));
        this.skillCollection = new CaseInsensitiveMap<FunctionCollection>(cloned);
    }

    public DefaultSkillCollection() {
        this.skillCollection = new CaseInsensitiveMap();
    }

    public DefaultSkillCollection addSemanticFunction(SKFunction functionInstance) {
        FunctionCollection existingFunctionCollection;
        if (!this.skillCollection.containsKey(functionInstance.getSkillName())) {
            existingFunctionCollection = new FunctionCollection(functionInstance.getSkillName());
            this.skillCollection.put(functionInstance.getSkillName(), existingFunctionCollection);
        } else {
            existingFunctionCollection = this.skillCollection.get(functionInstance.getSkillName());
        }
        existingFunctionCollection.put(functionInstance.getName(), functionInstance);
        return this;
    }

    @Nullable
    public <T extends SKFunction<?>> T getFunction(String funName, @Nullable Class<T> functionClazz) {
        return this.getFunction("_GLOBAL_FUNCTIONS_", funName, functionClazz);
    }

    @Nullable
    public <T extends SKFunction<?>> T getFunction(String skillName, String funName, @Nullable Class<T> functionClazz) {
        FunctionCollection skills = this.skillCollection.get(skillName.toLowerCase(Locale.ROOT));
        if (skills == null) {
            return null;
        }
        return skills.getFunction(funName, functionClazz);
    }

    @Nullable
    public FunctionCollection getFunctions(String skillName) {
        return this.skillCollection.get(skillName.toLowerCase(Locale.ROOT));
    }

    public boolean hasFunction(String functionName) {
        return this.getFunction(functionName, SKFunction.class) != null;
    }

    public boolean hasFunction(String skillName, String functionName) {
        FunctionCollection skills = this.skillCollection.get(skillName.toLowerCase(Locale.ROOT));
        if (skills == null) {
            return false;
        }
        return skills.getFunction(functionName) != null;
    }

    @CheckReturnValue
    public ReadOnlySkillCollection copy() {
        return new DefaultSkillCollection(this.skillCollection);
    }

    public DefaultSkillCollection addNativeFunction(SKFunction functionInstance) {
        return this.addSemanticFunction(functionInstance);
    }

    public DefaultSkillCollection merge(ReadOnlySkillCollection in) {
        in.asMap().entrySet().forEach(entry -> {
            FunctionCollection existing = this.skillCollection.get(((String)entry.getKey()).toLowerCase(Locale.ROOT));
            if (existing == null) {
                this.skillCollection.put(((String)entry.getKey()).toLowerCase(Locale.ROOT), new FunctionCollection((ReadOnlyFunctionCollection)entry.getValue()));
            } else {
                existing.merge(new FunctionCollection((ReadOnlyFunctionCollection)entry.getValue()));
            }
        });
        return this;
    }

    public Map<String, ReadOnlyFunctionCollection> asMap() {
        return Collections.unmodifiableMap(this.skillCollection);
    }

    public FunctionCollection getAllFunctions() {
        return this.skillCollection.values().stream().reduce(new FunctionCollection(""), FunctionCollection::merge);
    }

    public static class Builder
    implements ReadOnlySkillCollection.Builder {
        public ReadOnlySkillCollection build() {
            return new DefaultSkillCollection();
        }
    }
}

