/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.semanticfunctions;

import com.microsoft.semantickernel.orchestration.SKContext;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplate;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplateConfig;
import com.microsoft.semantickernel.skilldefinition.ParameterView;
import com.microsoft.semantickernel.templateengine.PromptTemplateEngine;
import com.microsoft.semantickernel.templateengine.blocks.BlockTypes;
import com.microsoft.semantickernel.templateengine.blocks.VarBlock;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import reactor.core.publisher.Mono;

public class DefaultPromptTemplate
implements PromptTemplate {
    private final String promptTemplate;
    private final PromptTemplateConfig config;
    private final PromptTemplateEngine templateEngine;

    public DefaultPromptTemplate(String promptTemplate, PromptTemplateConfig config, PromptTemplateEngine templateEngine) {
        this.promptTemplate = promptTemplate;
        this.config = config;
        this.templateEngine = templateEngine;
    }

    public List<ParameterView> getParameters() {
        List result = this.config.getInput().getParameters().stream().filter(Objects::nonNull).map(p -> new ParameterView(p.getName(), p.getDescription(), p.getDefaultValue())).collect(Collectors.toList());
        List seen = result.stream().map(ParameterView::getName).collect(Collectors.toList());
        List listFromTemplate = this.templateEngine.extractBlocks(this.promptTemplate).stream().filter(Objects::nonNull).filter(x -> x.getType() == BlockTypes.Variable).map(x -> (VarBlock)x).collect(Collectors.toList());
        List newParams = listFromTemplate.stream().filter(x -> !seen.contains(x.getName())).map(x -> new ParameterView(x.getName())).collect(Collectors.toList());
        return Stream.concat(result.stream(), newParams.stream()).collect(Collectors.toList());
    }

    public Mono<String> renderAsync(SKContext executionContext) {
        return this.templateEngine.renderAsync(this.promptTemplate, executionContext);
    }

    public static final class Builder
    implements PromptTemplate.Builder {
        @Nullable
        private String promptTemplate = null;
        @Nullable
        private PromptTemplateConfig config = null;
        @Nullable
        private PromptTemplateEngine promptTemplateEngine = null;

        public PromptTemplate.Builder withPromptTemplate(String promptTemplate) {
            this.promptTemplate = promptTemplate;
            return this;
        }

        public PromptTemplate.Builder withPromptTemplateConfig(PromptTemplateConfig config) {
            this.config = config;
            return this;
        }

        public PromptTemplate.Builder withPromptTemplateEngine(PromptTemplateEngine promptTemplateEngine) {
            this.promptTemplateEngine = promptTemplateEngine;
            return this;
        }

        public PromptTemplate build() {
            if (this.promptTemplate == null || this.config == null || this.promptTemplateEngine == null) {
                throw new IllegalStateException("PromptTemplate, PromptTemplateConfig and promptTemplateEngine must be set");
            }
            return new DefaultPromptTemplate(this.promptTemplate, this.config, this.promptTemplateEngine);
        }
    }
}

