/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.orchestration;

import com.microsoft.semantickernel.Kernel;
import com.microsoft.semantickernel.SKBuilders;
import com.microsoft.semantickernel.memory.SemanticTextMemory;
import com.microsoft.semantickernel.orchestration.AbstractSKContext;
import com.microsoft.semantickernel.orchestration.ContextVariables;
import com.microsoft.semantickernel.orchestration.SKContext;
import com.microsoft.semantickernel.skilldefinition.ReadOnlySkillCollection;
import javax.annotation.Nullable;

public class DefaultSKContext
extends AbstractSKContext {
    protected DefaultSKContext(SKContext toClone, String errorDescription, Exception exception) {
        super(toClone, errorDescription, exception);
    }

    public DefaultSKContext(ContextVariables variables) {
        super(variables);
    }

    public DefaultSKContext(ContextVariables variables, @Nullable SemanticTextMemory memory, @Nullable ReadOnlySkillCollection skillCollection) {
        super(variables, memory, skillCollection);
    }

    protected SKContext getThis() {
        return this;
    }

    public SKContext build(ContextVariables variables, @Nullable SemanticTextMemory memory, @Nullable ReadOnlySkillCollection skillCollection) {
        return new DefaultSKContext(variables, memory, skillCollection);
    }

    public static class Builder
    implements SKContext.Builder {
        private ContextVariables variables;
        private ReadOnlySkillCollection skills;
        private SemanticTextMemory memory;

        public SKContext failed(SKContext toClone, String errorDescription, Exception exception) {
            return new DefaultSKContext(toClone, errorDescription, exception);
        }

        public SKContext build() {
            if (this.variables == null) {
                this.variables = (ContextVariables)SKBuilders.variables().build();
            }
            return new DefaultSKContext(this.variables, this.memory, this.skills);
        }

        public SKContext.Builder withVariables(ContextVariables variables) {
            this.variables = variables;
            return this;
        }

        public SKContext.Builder withSkills(@Nullable ReadOnlySkillCollection skills) {
            if (skills != null) {
                this.skills = skills;
            }
            return this;
        }

        public SKContext.Builder withMemory(@Nullable SemanticTextMemory memory) {
            if (memory != null) {
                this.memory = memory.copy();
            }
            return this;
        }

        public SKContext.Builder clone(SKContext context) {
            return this.withVariables(context.getVariables()).withSkills(context.getSkills()).withMemory(context.getSemanticMemory());
        }

        public SKContext.Builder withKernel(Kernel kernel) {
            if (this.memory == null) {
                this.memory = kernel.getMemory();
            }
            if (this.skills == null) {
                this.skills = kernel.getSkills();
            }
            if (this.variables == null) {
                this.variables = (ContextVariables)SKBuilders.variables().build();
            }
            return this;
        }
    }
}

