/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.orchestration;

import com.microsoft.semantickernel.orchestration.ContextVariables;
import com.microsoft.semantickernel.orchestration.WritableContextVariables;
import com.microsoft.semantickernel.skilldefinition.CaseInsensitiveMap;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import reactor.util.annotation.NonNull;

class DefaultContextVariables
implements ContextVariables,
WritableContextVariables {
    private final CaseInsensitiveMap<String> variables;

    DefaultContextVariables(@NonNull String content) {
        this.variables = new CaseInsensitiveMap();
        this.variables.put("input", content);
    }

    DefaultContextVariables(Map<String, String> variables) {
        this.variables = new CaseInsensitiveMap<String>(variables);
    }

    public ContextVariables setVariable(@NonNull String key, @NonNull String content) {
        this.variables.put(key, content);
        return this;
    }

    public ContextVariables appendToVariable(@NonNull String key, @NonNull String content) {
        String existing = this.variables.get(key);
        String newVal = existing == null ? content : existing + content;
        return this.setVariable(key, newVal);
    }

    public Map<String, String> asMap() {
        return Collections.unmodifiableMap(this.variables);
    }

    public ContextVariables update(@NonNull String content) {
        return this.setVariable("input", content);
    }

    public DefaultContextVariables update(@NonNull DefaultContextVariables newData) {
        return this.update(newData, true);
    }

    public DefaultContextVariables update(@NonNull ContextVariables newData, boolean merge) {
        this.variables.putAll(newData.asMap());
        return this;
    }

    public ContextVariables remove(String key) {
        this.variables.remove(key);
        return this;
    }

    public WritableContextVariables writableClone() {
        return new DefaultContextVariables(this.variables);
    }

    @Nullable
    public String getInput() {
        return this.get("input");
    }

    public String prettyPrint() {
        return this.variables.entrySet().stream().reduce("", (str, entry) -> str + System.lineSeparator() + (String)entry.getKey() + ": " + (String)entry.getValue(), (a, b) -> a + b);
    }

    @Nullable
    public String get(String key) {
        return this.variables.get(key);
    }

    public static class Builder
    implements ContextVariables.Builder {
        private final Map<String, String> variables = new CaseInsensitiveMap<String>();

        public Builder() {
            this.variables.put("input", "");
        }

        public ContextVariables.Builder withVariable(String key, String value) {
            this.variables.put(key, value);
            return this;
        }

        public Builder withInput(String content) {
            this.variables.put("input", content);
            return this;
        }

        public Builder withVariables(Map<String, String> map) {
            this.variables.putAll(map);
            return this;
        }

        public ContextVariables build() {
            return new DefaultContextVariables(this.variables);
        }
    }

    public static class WritableBuilder
    implements WritableContextVariables.Builder {
        public WritableContextVariables build(Map<String, String> map) {
            return new DefaultContextVariables(map);
        }
    }
}

