/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.orchestration;

import com.azure.core.exception.HttpResponseException;
import com.microsoft.semantickernel.Kernel;
import com.microsoft.semantickernel.SKBuilders;
import com.microsoft.semantickernel.ai.AIException;
import com.microsoft.semantickernel.orchestration.ContextVariables;
import com.microsoft.semantickernel.orchestration.DefaultSemanticSKFunction;
import com.microsoft.semantickernel.orchestration.DefaultTextCompletionSupplier;
import com.microsoft.semantickernel.orchestration.FunctionNotRegisteredException;
import com.microsoft.semantickernel.orchestration.SKContext;
import com.microsoft.semantickernel.orchestration.SKFunction;
import com.microsoft.semantickernel.orchestration.SKSemanticAsyncTask;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplate;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplateConfig;
import com.microsoft.semantickernel.semanticfunctions.SemanticFunctionConfig;
import com.microsoft.semantickernel.skilldefinition.FunctionView;
import com.microsoft.semantickernel.skilldefinition.KernelSkillsSupplier;
import com.microsoft.semantickernel.skilldefinition.ParameterView;
import com.microsoft.semantickernel.skilldefinition.ReadOnlySkillCollection;
import com.microsoft.semantickernel.textcompletion.CompletionRequestSettings;
import com.microsoft.semantickernel.textcompletion.CompletionSKFunction;
import com.microsoft.semantickernel.textcompletion.TextCompletion;
import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultCompletionSKFunction
extends DefaultSemanticSKFunction<CompletionRequestSettings>
implements CompletionSKFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCompletionSKFunction.class);
    private final SemanticFunctionConfig functionConfig;
    private SKSemanticAsyncTask<SKContext> function;
    private final CompletionRequestSettings requestSettings;
    @Nullable
    private DefaultTextCompletionSupplier aiService;

    public DefaultCompletionSKFunction(List<ParameterView> parameters, String skillName, String functionName, String description, CompletionRequestSettings requestSettings, SemanticFunctionConfig functionConfig, @Nullable KernelSkillsSupplier kernelSkillsSupplier) {
        super(parameters, skillName, functionName, description, kernelSkillsSupplier);
        this.requestSettings = requestSettings;
        this.functionConfig = functionConfig;
    }

    private SKContext buildContext() {
        this.assertSkillSupplierRegistered();
        return (SKContext)SKBuilders.context().withVariables((ContextVariables)SKBuilders.variables().build()).withSkills(this.getSkillsSupplier() == null ? null : (ReadOnlySkillCollection)this.getSkillsSupplier().get()).build();
    }

    public Mono<SKContext> aggregatePartitionedResultsAsync(List<String> partitionedInput, @Nullable SKContext contextIn) {
        SKContext context = contextIn == null ? this.buildContext() : contextIn;
        BiFunction<Flux, String, Flux> executeNextChunk = (contextInput, input) -> contextInput.concatMap(newContext -> {
            SKContext updated = newContext.copy().update(input);
            return this.invokeAsync(updated, null);
        });
        Flux results = Flux.fromIterable(partitionedInput).scanWith(() -> Flux.just((Object)context), executeNextChunk).skip(1L).concatMap(it -> it);
        return results.map(result -> result.getResult()).collect(Collectors.joining("\n")).map(arg_0 -> ((SKContext)context).update(arg_0));
    }

    protected Mono<SKContext> invokeAsyncInternal(SKContext context, @Nullable CompletionRequestSettings settings) {
        if (this.function == null) {
            throw new FunctionNotRegisteredException(FunctionNotRegisteredException.ErrorCodes.FUNCTION_NOT_REGISTERED, this.getName());
        }
        if (settings == null) {
            settings = this.requestSettings;
        }
        if (this.aiService.get() == null) {
            throw new IllegalStateException("Failed to initialise aiService");
        }
        CompletionRequestSettings finalSettings = settings;
        return this.function.run((TextCompletion)this.aiService.get(), finalSettings, context).map(result -> context.update(result.getVariables()));
    }

    public void registerOnKernel(Kernel kernel) {
        this.function = (client, requestSettings, contextInput) -> {
            SKContext context = contextInput.copy();
            PromptTemplate func = this.functionConfig.getTemplate();
            return func.renderAsync(context).flatMap(prompt -> DefaultCompletionSKFunction.performCompletionRequest(client, requestSettings, prompt, context)).doOnError(ex -> {
                LOGGER.warn("Something went wrong while rendering the semantic function or while executing the text completion. Function: {}.{}. Error: {}", new Object[]{this.getSkillName(), this.getName(), ex.getMessage()});
                if (ex instanceof HttpResponseException && ((HttpResponseException)ex).getResponse().getStatusCode() == 400 && ex.getMessage().contains("parameters are not available on")) {
                    LOGGER.warn("This error indicates that you have attempted to use a chat completion model in a text completion service. Try using a chat completion service instead when building your kernel, for instance when building your service use SKBuilders.chatCompletion() rather than SKBuilders.textCompletionService().");
                }
            });
        };
        this.setSkillsSupplier(() -> ((Kernel)kernel).getSkills());
        this.aiService = () -> (TextCompletion)kernel.getService(null, TextCompletion.class);
    }

    private static Mono<SKContext> performCompletionRequest(TextCompletion client, CompletionRequestSettings requestSettings, String prompt, SKContext context) {
        LOGGER.debug("RENDERED PROMPT: \n{}", (Object)prompt);
        switch (client.defaultCompletionType()) {
            case NON_STREAMING: {
                return client.completeAsync(prompt, requestSettings).single().map(completion -> context.update((String)completion.get(0)));
            }
        }
        return client.completeStreamAsync(prompt, requestSettings).filter(completion -> !completion.isEmpty()).take(1L).single().map(arg_0 -> ((SKContext)context).update(arg_0));
    }

    public Class<CompletionRequestSettings> getType() {
        return CompletionRequestSettings.class;
    }

    private static String randomFunctionName() {
        return "func" + UUID.randomUUID();
    }

    public FunctionView describe() {
        return new FunctionView(super.getName(), super.getSkillName(), super.getDescription(), super.getParametersView(), true, false);
    }

    public static class Builder
    implements CompletionSKFunction.Builder {
        private Kernel kernel;
        @Nullable
        private String promptTemplate = null;
        @Nullable
        private String functionName = null;
        @Nullable
        private String skillName = null;
        @Nullable
        private String description = null;
        private PromptTemplateConfig.CompletionConfig completionConfig = new PromptTemplateConfig.CompletionConfig();
        @Nullable
        private SemanticFunctionConfig functionConfig = null;
        @Nullable
        private PromptTemplateConfig promptTemplateConfig = null;

        public CompletionSKFunction build() {
            if (this.kernel == null) {
                throw new AIException(AIException.ErrorCodes.INVALID_CONFIGURATION, "Called builder to create a function without setting the kernel");
            }
            if (this.functionName == null) {
                this.functionName = DefaultCompletionSKFunction.randomFunctionName();
            }
            if (this.skillName == null) {
                this.skillName = "_GLOBAL_FUNCTIONS_";
            }
            if (this.functionConfig == null) {
                if (this.description == null) {
                    this.description = "Generic function, unknown purpose";
                }
                if (this.promptTemplate == null) {
                    throw new AIException(AIException.ErrorCodes.INVALID_CONFIGURATION, "Must set prompt template before building");
                }
                if (this.promptTemplateConfig == null) {
                    this.promptTemplateConfig = new PromptTemplateConfig(this.description, "completion", this.completionConfig);
                }
                PromptTemplate template = (PromptTemplate)SKBuilders.promptTemplate().withPromptTemplateConfig(this.promptTemplateConfig).withPromptTemplate(this.promptTemplate).withPromptTemplateEngine(this.kernel.getPromptTemplateEngine()).build();
                this.functionConfig = new SemanticFunctionConfig(this.promptTemplateConfig, template);
            }
            CompletionRequestSettings requestSettings = CompletionRequestSettings.fromCompletionConfig((PromptTemplateConfig.CompletionConfig)this.functionConfig.getConfig().getCompletionConfig());
            PromptTemplate promptTemplate = this.functionConfig.getTemplate();
            DefaultCompletionSKFunction function = new DefaultCompletionSKFunction(promptTemplate.getParameters(), this.skillName, this.functionName, this.functionConfig.getConfig().getDescription(), requestSettings, this.functionConfig, null);
            this.kernel.registerSemanticFunction((SKFunction)function);
            return function;
        }

        public CompletionSKFunction.Builder withKernel(Kernel kernel) {
            this.kernel = kernel;
            return this;
        }

        public CompletionSKFunction.Builder withPromptTemplate(String promptTemplate) {
            this.promptTemplate = promptTemplate;
            return this;
        }

        public CompletionSKFunction.Builder withPromptTemplateConfig(PromptTemplateConfig promptTemplateConfig) {
            this.promptTemplateConfig = promptTemplateConfig;
            return this;
        }

        public CompletionSKFunction.Builder withCompletionConfig(PromptTemplateConfig.CompletionConfig completionConfig) {
            this.completionConfig = completionConfig;
            return this;
        }

        public CompletionSKFunction.Builder withSemanticFunctionConfig(SemanticFunctionConfig functionConfig) {
            this.functionConfig = functionConfig;
            return this;
        }

        public CompletionSKFunction.Builder withSkillName(@Nullable String skillName) {
            this.skillName = skillName;
            return this;
        }

        public CompletionSKFunction.Builder withFunctionName(@Nullable String functionName) {
            this.functionName = functionName;
            return this;
        }

        public CompletionSKFunction.Builder withDescription(String description) {
            this.description = description;
            return this;
        }
    }
}

