/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.memory;

import com.microsoft.semantickernel.ai.embeddings.Embedding;
import com.microsoft.semantickernel.memory.MemoryException;
import com.microsoft.semantickernel.memory.MemoryRecord;
import com.microsoft.semantickernel.memory.MemoryRecordMetadata;
import com.microsoft.semantickernel.memory.MemoryStore;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class VolatileMemoryStore
implements MemoryStore {
    private final Map<String, Map<String, MemoryRecord>> _store = new ConcurrentHashMap<String, Map<String, MemoryRecord>>();

    public Mono<Void> createCollectionAsync(@Nonnull String collectionName) {
        Objects.requireNonNull(collectionName);
        return Mono.fromRunnable(() -> this._store.putIfAbsent(collectionName, new ConcurrentHashMap()));
    }

    public Mono<Boolean> doesCollectionExistAsync(@Nonnull String collectionName) {
        Objects.requireNonNull(collectionName);
        return Mono.just((Object)this._store.containsKey(collectionName));
    }

    public Mono<List<String>> getCollectionsAsync() {
        return Mono.just(Collections.unmodifiableList(new ArrayList<String>(this._store.keySet())));
    }

    public Mono<Void> deleteCollectionAsync(@Nonnull String collectionName) {
        Objects.requireNonNull(collectionName);
        return Mono.fromRunnable(() -> {
            if (!this._store.containsKey(collectionName)) {
                throw new MemoryException(MemoryException.ErrorCodes.ATTEMPTED_TO_ACCESS_NONEXISTENT_COLLECTION, collectionName);
            }
            this._store.remove(collectionName);
        });
    }

    public Mono<String> upsertAsync(@Nonnull String collectionName, @Nonnull MemoryRecord record) {
        Objects.requireNonNull(collectionName);
        Objects.requireNonNull(record);
        return Mono.fromCallable(() -> {
            Map collection = this._store.computeIfAbsent(collectionName, k -> new ConcurrentHashMap());
            String key = record.getMetadata().getId();
            assert (key != null);
            collection.put(key, record);
            return key;
        });
    }

    public Mono<Collection<String>> upsertBatchAsync(@Nonnull String collectionName, @Nonnull Collection<MemoryRecord> records) {
        Objects.requireNonNull(collectionName);
        Objects.requireNonNull(records);
        return Mono.fromCallable(() -> {
            Map collection = this._store.computeIfAbsent(collectionName, k -> new ConcurrentHashMap());
            HashSet keys = new HashSet();
            records.forEach(record -> {
                String key = record.getMetadata().getId();
                assert (key != null);
                collection.put(key, record);
                keys.add(key);
            });
            return keys;
        });
    }

    public Mono<MemoryRecord> getAsync(@Nonnull String collectionName, @Nonnull String key, boolean withEmbedding) {
        Objects.requireNonNull(collectionName);
        Objects.requireNonNull(key);
        return Mono.fromCallable(() -> {
            MemoryRecord record;
            Map<String, MemoryRecord> collection = this._store.get(collectionName);
            MemoryRecord memoryRecord = record = collection != null ? collection.get(key) : null;
            if (record != null) {
                if (withEmbedding) {
                    return record;
                }
                return MemoryRecord.fromMetadata((MemoryRecordMetadata)record.getMetadata(), null, (String)record.getMetadata().getId(), (ZonedDateTime)record.getTimestamp());
            }
            return null;
        });
    }

    public Mono<Collection<MemoryRecord>> getBatchAsync(@Nonnull String collectionName, @Nonnull Collection<String> keys, boolean withEmbeddings) {
        Objects.requireNonNull(collectionName);
        Objects.requireNonNull(keys);
        return Mono.fromCallable(() -> {
            Map<String, MemoryRecord> collection = this.getCollection(collectionName);
            HashSet records = new HashSet();
            keys.forEach(key -> {
                MemoryRecord record = (MemoryRecord)collection.get(key);
                if (record != null) {
                    if (withEmbeddings) {
                        records.add(record);
                    } else {
                        records.add(MemoryRecord.fromMetadata((MemoryRecordMetadata)record.getMetadata(), null, (String)record.getMetadata().getId(), (ZonedDateTime)record.getTimestamp()));
                    }
                }
            });
            return records;
        });
    }

    public Mono<Void> removeAsync(@Nonnull String collectionName, @Nonnull String key) {
        return Mono.fromRunnable(() -> {
            Map<String, MemoryRecord> collection = this._store.get(collectionName);
            if (collection != null) {
                collection.remove(key);
            }
        });
    }

    public Mono<Void> removeBatchAsync(@Nonnull String collectionName, @Nonnull Collection<String> keys) {
        return Mono.fromRunnable(() -> {
            Map<String, MemoryRecord> collection = this._store.get(collectionName);
            keys.forEach(collection::remove);
        });
    }

    public Mono<Collection<Tuple2<MemoryRecord, Float>>> getNearestMatchesAsync(@Nonnull String collectionName, @Nonnull Embedding embedding, int limit, float minRelevanceScore, boolean withEmbeddings) {
        Objects.requireNonNull(collectionName);
        Objects.requireNonNull(embedding);
        if (limit <= 0) {
            return Mono.just(Collections.emptyList());
        }
        return Mono.fromCallable(() -> {
            Map<String, MemoryRecord> collection = this.getCollection(collectionName);
            if (collection == null || collection.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList nearestMatches = new ArrayList();
            collection.values().forEach(record -> {
                float similarity;
                if (record != null && (similarity = embedding.cosineSimilarity(record.getEmbedding())) >= minRelevanceScore) {
                    if (withEmbeddings) {
                        nearestMatches.add(Tuples.of((Object)record, (Object)Float.valueOf(similarity)));
                    } else {
                        nearestMatches.add(Tuples.of((Object)MemoryRecord.fromMetadata((MemoryRecordMetadata)record.getMetadata(), null, (String)record.getMetadata().getId(), (ZonedDateTime)record.getTimestamp()), (Object)Float.valueOf(similarity)));
                    }
                }
            });
            List result = nearestMatches.stream().sorted(Comparator.comparing(Tuple2::getT2, (a, b) -> Float.compare(b.floatValue(), a.floatValue()))).limit(limit).collect(Collectors.toList());
            return result;
        });
    }

    public Mono<Tuple2<MemoryRecord, Float>> getNearestMatchAsync(@Nonnull String collectionName, @Nonnull Embedding embedding, float minRelevanceScore, boolean withEmbedding) {
        Objects.requireNonNull(collectionName);
        Objects.requireNonNull(embedding);
        return this.getNearestMatchesAsync(collectionName, embedding, 1, minRelevanceScore, withEmbedding).flatMap(nearestMatches -> {
            if (nearestMatches.isEmpty()) {
                return Mono.empty();
            }
            return Mono.just((Object)((Tuple2)nearestMatches.iterator().next()));
        });
    }

    protected Map<String, MemoryRecord> getCollection(@Nonnull String collectionName) {
        Objects.requireNonNull(collectionName);
        Map<String, MemoryRecord> collection = this._store.get(collectionName);
        if (collection == null) {
            throw new MemoryException(MemoryException.ErrorCodes.ATTEMPTED_TO_ACCESS_NONEXISTENT_COLLECTION, collectionName);
        }
        return collection;
    }

    public static class Builder
    implements MemoryStore.Builder<VolatileMemoryStore> {
        public VolatileMemoryStore build() {
            return new VolatileMemoryStore();
        }
    }
}

