/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.memory;

import com.microsoft.semantickernel.DefaultKernel;
import com.microsoft.semantickernel.ai.embeddings.EmbeddingGeneration;
import com.microsoft.semantickernel.memory.DefaultSemanticTextMemory;
import com.microsoft.semantickernel.memory.MemoryStore;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MemoryConfiguration {
    public static void useMemory(@Nonnull DefaultKernel kernel, @Nonnull MemoryStore storage, @Nullable String embeddingsServiceId) {
        Objects.requireNonNull(kernel);
        Objects.requireNonNull(storage);
        EmbeddingGeneration embeddingGenerator = kernel.getService(embeddingsServiceId, EmbeddingGeneration.class);
        MemoryConfiguration.useMemory(kernel, (EmbeddingGeneration<String>)embeddingGenerator, storage);
    }

    public static void useMemory(@Nonnull DefaultKernel kernel, EmbeddingGeneration<String> embeddingGenerator, MemoryStore storage) {
        Objects.requireNonNull(kernel);
        Objects.requireNonNull(embeddingGenerator);
        Objects.requireNonNull(storage);
        kernel.registerMemory(new DefaultSemanticTextMemory(storage, embeddingGenerator));
    }
}

