/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.memory;

import com.microsoft.semantickernel.ai.embeddings.Embedding;
import com.microsoft.semantickernel.ai.embeddings.EmbeddingGeneration;
import com.microsoft.semantickernel.memory.MemoryQueryResult;
import com.microsoft.semantickernel.memory.MemoryRecord;
import com.microsoft.semantickernel.memory.MemoryRecordMetadata;
import com.microsoft.semantickernel.memory.MemoryStore;
import com.microsoft.semantickernel.memory.SemanticTextMemory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class DefaultSemanticTextMemory
implements SemanticTextMemory {
    @Nonnull
    private final EmbeddingGeneration<String> _embeddingGenerator;
    @Nonnull
    private MemoryStore _storage;
    private static final Function<Collection<Tuple2<MemoryRecord, Float>>, Mono<List<MemoryQueryResult>>> transformMatchesToResults = records -> {
        if (records.isEmpty()) {
            return Mono.empty();
        }
        return Mono.just(records.stream().map(record -> {
            Tuple2 tuple = record;
            MemoryRecord memoryRecord = (MemoryRecord)tuple.getT1();
            Number relevanceScore = (Number)tuple.getT2();
            return new MemoryQueryResult(memoryRecord.getMetadata(), relevanceScore.doubleValue());
        }).collect(Collectors.toList()));
    };

    public DefaultSemanticTextMemory(@Nonnull MemoryStore storage, @Nonnull EmbeddingGeneration<String> embeddingGenerator) {
        this._embeddingGenerator = embeddingGenerator;
        this._storage = storage;
    }

    public SemanticTextMemory copy() {
        return new DefaultSemanticTextMemory(this._storage, this._embeddingGenerator);
    }

    public Mono<String> saveInformationAsync(@Nonnull String collection, @Nonnull String text, @Nonnull String id, @Nullable String description, @Nullable String additionalMetadata) {
        Mono embedAndSave = this._embeddingGenerator.generateEmbeddingsAsync(Collections.singletonList(text)).flatMap(embeddings -> {
            if (embeddings.isEmpty()) {
                return Mono.empty();
            }
            MemoryRecordMetadata data = new MemoryRecordMetadata(true, id, text, description, "", additionalMetadata);
            MemoryRecord memoryRecord = new MemoryRecord(data, (Embedding)embeddings.iterator().next(), id, null);
            return this._storage.upsertAsync(collection, memoryRecord).onErrorResume(e -> this._storage.createCollectionAsync(collection).then(this._storage.upsertAsync(collection, memoryRecord)));
        });
        return this._storage.getAsync(collection, id, false).filter(memoryRecord -> memoryRecord.getMetadata().getText().equals(text)).map(record -> record.getMetadata().getId()).switchIfEmpty(embedAndSave);
    }

    public Mono<MemoryQueryResult> getAsync(String collection, String key, boolean withEmbedding) {
        return this._storage.getAsync(collection, key, withEmbedding).map(record -> new MemoryQueryResult(record.getMetadata(), 1.0));
    }

    public Mono<Void> removeAsync(@Nonnull String collection, @Nonnull String key) {
        return this._storage.removeAsync(collection, key);
    }

    public Mono<List<MemoryQueryResult>> searchAsync(@Nonnull String collection, @Nonnull String query, int limit, float minRelevanceScore, boolean withEmbeddings) {
        return this._embeddingGenerator.generateEmbeddingsAsync(Collections.singletonList(query)).flatMap(embeddings -> {
            if (embeddings.isEmpty()) {
                return Mono.empty();
            }
            return this._storage.getNearestMatchesAsync(collection, (Embedding)embeddings.iterator().next(), limit, minRelevanceScore, withEmbeddings).flatMap(transformMatchesToResults);
        });
    }

    public Mono<List<String>> getCollectionsAsync() {
        return this._storage.getCollectionsAsync();
    }

    public Mono<String> saveReferenceAsync(@Nonnull String collection, @Nonnull String text, @Nonnull String externalId, @Nonnull String externalSourceName, @Nullable String description, @Nullable String additionalMetadata) {
        return this._storage.doesCollectionExistAsync(collection).map(exists -> {
            if (!exists.booleanValue()) {
                return this._storage.createCollectionAsync(collection);
            }
            return Mono.empty();
        }).then(this._embeddingGenerator.generateEmbeddingsAsync(Collections.singletonList(text))).map(embeddings -> MemoryRecord.referenceRecord((String)externalId, (String)externalSourceName, (String)description, (Embedding)((Embedding)embeddings.iterator().next()), (String)additionalMetadata, null, null)).flatMap(record -> this._storage.upsertAsync(collection, record));
    }

    public static class Builder
    implements SemanticTextMemory.Builder {
        @Nullable
        MemoryStore storage = null;
        @Nullable
        EmbeddingGeneration<String> embeddingGenerator = null;

        public Builder withStorage(@Nonnull MemoryStore storage) {
            this.storage = storage;
            return this;
        }

        public Builder withEmbeddingGenerator(@Nonnull EmbeddingGeneration<String> embeddingGenerator) {
            this.embeddingGenerator = embeddingGenerator;
            return this;
        }

        public SemanticTextMemory build() {
            if (this.storage == null) {
                throw new IllegalStateException("Storage must be set");
            }
            if (this.embeddingGenerator == null) {
                throw new IllegalStateException("Embedding generator must be set");
            }
            return new DefaultSemanticTextMemory(this.storage, this.embeddingGenerator);
        }
    }
}

