/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel;

import com.microsoft.semantickernel.Kernel;
import com.microsoft.semantickernel.KernelConfig;
import com.microsoft.semantickernel.KernelException;
import com.microsoft.semantickernel.SKBuilders;
import com.microsoft.semantickernel.SKException;
import com.microsoft.semantickernel.Verify;
import com.microsoft.semantickernel.ai.AIException;
import com.microsoft.semantickernel.ai.embeddings.EmbeddingGeneration;
import com.microsoft.semantickernel.ai.embeddings.TextEmbeddingGeneration;
import com.microsoft.semantickernel.coreskills.SkillImporter;
import com.microsoft.semantickernel.exceptions.SkillsNotFoundException;
import com.microsoft.semantickernel.extensions.KernelExtensions;
import com.microsoft.semantickernel.memory.MemoryConfiguration;
import com.microsoft.semantickernel.memory.MemoryStore;
import com.microsoft.semantickernel.memory.NullMemory;
import com.microsoft.semantickernel.memory.SemanticTextMemory;
import com.microsoft.semantickernel.orchestration.ContextVariables;
import com.microsoft.semantickernel.orchestration.RegistrableSkFunction;
import com.microsoft.semantickernel.orchestration.SKContext;
import com.microsoft.semantickernel.orchestration.SKFunction;
import com.microsoft.semantickernel.semanticfunctions.SemanticFunctionConfig;
import com.microsoft.semantickernel.services.AIService;
import com.microsoft.semantickernel.services.AIServiceCollection;
import com.microsoft.semantickernel.services.AIServiceProvider;
import com.microsoft.semantickernel.skilldefinition.DefaultSkillCollection;
import com.microsoft.semantickernel.skilldefinition.FunctionCollection;
import com.microsoft.semantickernel.skilldefinition.FunctionNotFound;
import com.microsoft.semantickernel.skilldefinition.ReadOnlyFunctionCollection;
import com.microsoft.semantickernel.skilldefinition.ReadOnlySkillCollection;
import com.microsoft.semantickernel.templateengine.DefaultPromptTemplateEngine;
import com.microsoft.semantickernel.templateengine.PromptTemplateEngine;
import com.microsoft.semantickernel.textcompletion.CompletionSKFunction;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.core.publisher.Mono;

public class DefaultKernel
implements Kernel {
    private final KernelConfig kernelConfig;
    private final DefaultSkillCollection defaultSkillCollection;
    private final PromptTemplateEngine promptTemplateEngine;
    private final AIServiceProvider aiServiceProvider;
    private SemanticTextMemory memory;

    @Inject
    public DefaultKernel(KernelConfig kernelConfig, PromptTemplateEngine promptTemplateEngine, @Nullable SemanticTextMemory memoryStore, AIServiceProvider aiServiceProvider) {
        if (kernelConfig == null) {
            throw new IllegalArgumentException();
        }
        this.kernelConfig = kernelConfig;
        this.aiServiceProvider = aiServiceProvider;
        this.promptTemplateEngine = promptTemplateEngine;
        this.defaultSkillCollection = new DefaultSkillCollection();
        this.memory = memoryStore != null ? memoryStore.copy() : new NullMemory();
    }

    public <T extends AIService> T getService(String serviceId, Class<T> clazz) {
        AIService service = (AIService)this.aiServiceProvider.getService(serviceId, clazz);
        if (service == null) {
            throw new KernelException(KernelException.ErrorCodes.SERVICE_NOT_FOUND, "Service of type " + clazz.getName() + " and name " + serviceId + " not registered");
        }
        return (T)service;
    }

    public KernelConfig getConfig() {
        return this.kernelConfig;
    }

    public <RequestConfiguration, FunctionType extends SKFunction<RequestConfiguration>> FunctionType registerSemanticFunction(FunctionType func) {
        if (!(func instanceof RegistrableSkFunction)) {
            throw new RuntimeException("This function does not implement RegistrableSkFunction");
        }
        ((RegistrableSkFunction)func).registerOnKernel((Kernel)this);
        this.defaultSkillCollection.addSemanticFunction(func);
        return func;
    }

    public SKFunction<?> getFunction(String skill, String function) {
        return this.defaultSkillCollection.getFunction(skill, function, null);
    }

    public CompletionSKFunction registerSemanticFunction(String skillName, String functionName, SemanticFunctionConfig functionConfig) {
        return (CompletionSKFunction)SKBuilders.completionFunctions().withSemanticFunctionConfig(functionConfig).withFunctionName(functionName).withSkillName(skillName).withKernel((Kernel)this).build();
    }

    public ReadOnlyFunctionCollection importSkill(String skillName, Map<String, SemanticFunctionConfig> skills) throws SkillsNotFoundException {
        skills.entrySet().stream().map(entry -> (CompletionSKFunction)SKBuilders.completionFunctions().withKernel((Kernel)this).withSkillName(skillName).withFunctionName((String)entry.getKey()).withSemanticFunctionConfig((SemanticFunctionConfig)entry.getValue()).build()).forEach(this::registerSemanticFunction);
        ReadOnlyFunctionCollection collection = this.getSkill(skillName);
        if (collection == null) {
            throw new SkillsNotFoundException(SkillsNotFoundException.ErrorCodes.SKILLS_NOT_FOUND);
        }
        return collection;
    }

    public ReadOnlyFunctionCollection importSkill(Object skillInstance, @Nullable String skillName) {
        if (skillInstance instanceof String) {
            throw new KernelException(KernelException.ErrorCodes.FUNCTION_NOT_AVAILABLE, "Called importSkill with a string argument, it is likely the intention was to call importSkillFromDirectory");
        }
        if (skillName == null || skillName.isEmpty()) {
            skillName = "_GLOBAL_FUNCTIONS_";
        }
        FunctionCollection functions = SkillImporter.importSkill(skillInstance, skillName, () -> this.defaultSkillCollection);
        DefaultSkillCollection newSkills = functions.getAll().stream().reduce(new DefaultSkillCollection(), DefaultSkillCollection::addNativeFunction, DefaultSkillCollection::merge);
        this.defaultSkillCollection.merge(newSkills);
        return functions;
    }

    public ReadOnlySkillCollection getSkills() {
        return this.defaultSkillCollection;
    }

    public CompletionSKFunction.Builder getSemanticFunctionBuilder() {
        return SKBuilders.completionFunctions().withKernel((Kernel)this);
    }

    public ReadOnlyFunctionCollection getSkill(String skillName) throws FunctionNotFound {
        FunctionCollection functions = this.defaultSkillCollection.getFunctions(skillName);
        if (functions == null) {
            throw new FunctionNotFound(FunctionNotFound.ErrorCodes.FUNCTION_NOT_FOUND, skillName);
        }
        return functions;
    }

    public ReadOnlyFunctionCollection importSkillFromDirectory(String skillName, String parentDirectory, String skillDirectoryName) {
        Map skills = KernelExtensions.importSemanticSkillFromDirectory((String)parentDirectory, (String)skillDirectoryName, (PromptTemplateEngine)this.promptTemplateEngine);
        return this.importSkill(skillName, skills);
    }

    public void importSkillsFromDirectory(String parentDirectory, String ... skillNames) {
        Arrays.stream(skillNames).forEach(skill -> this.importSkillFromDirectory((String)skill, parentDirectory, (String)skill));
    }

    public ReadOnlyFunctionCollection importSkillFromDirectory(String skillName, String parentDirectory) {
        return this.importSkillFromDirectory(skillName, parentDirectory, skillName);
    }

    public ReadOnlyFunctionCollection importSkillFromResources(String pluginDirectory, String skillName, String functionName) {
        return this.importSkillFromResources(pluginDirectory, skillName, functionName, null);
    }

    public ReadOnlyFunctionCollection importSkillFromResources(String pluginDirectory, String skillName, String functionName, @Nullable Class clazz) {
        Map skills = KernelExtensions.importSemanticSkillFromResourcesDirectory((String)pluginDirectory, (String)skillName, (String)functionName, (Class)clazz, (PromptTemplateEngine)this.promptTemplateEngine);
        return this.importSkill(skillName, skills);
    }

    public PromptTemplateEngine getPromptTemplateEngine() {
        return this.promptTemplateEngine;
    }

    public SemanticTextMemory getMemory() {
        return this.memory;
    }

    public void registerMemory(@Nonnull SemanticTextMemory memory) {
        this.memory = memory;
    }

    public Mono<SKContext> runAsync(SKFunction<?> ... pipeline) {
        return this.runAsync((ContextVariables)SKBuilders.variables().build(), pipeline);
    }

    public Mono<SKContext> runAsync(String input, SKFunction<?> ... pipeline) {
        return this.runAsync((ContextVariables)SKBuilders.variables().withInput(input).build(), pipeline);
    }

    public Mono<SKContext> runAsync(ContextVariables variables, SKFunction<?> ... pipeline) {
        if (pipeline == null || pipeline.length == 0) {
            throw new SKException("No parameters provided to pipeline");
        }
        Mono pipelineBuilder = Mono.just((Object)((SKContext)SKBuilders.context().withVariables(variables).withSkills(this.getSkills()).build()));
        for (SKFunction<?> f : Arrays.asList(pipeline)) {
            pipelineBuilder = pipelineBuilder.switchIfEmpty(Mono.fromCallable(() -> (SKContext)SKBuilders.context().withVariables(variables).withSkills(this.getSkills()).build())).flatMap(newContext -> {
                SKContext context = (SKContext)SKBuilders.context().withVariables(newContext.getVariables()).withMemory(newContext.getSemanticMemory()).withSkills(newContext.getSkills()).build();
                return f.invokeAsync(context, null);
            });
        }
        return pipelineBuilder;
    }

    public static class Builder
    implements Kernel.Builder {
        @Nullable
        private KernelConfig config = null;
        @Nullable
        private PromptTemplateEngine promptTemplateEngine = null;
        @Nullable
        private final AIServiceCollection aiServices = new AIServiceCollection();
        private Supplier<SemanticTextMemory> memoryFactory = NullMemory::new;
        private Supplier<MemoryStore> memoryStorageFactory = null;

        public Kernel.Builder withConfiguration(KernelConfig kernelConfig) {
            this.config = kernelConfig;
            return this;
        }

        public Kernel.Builder withPromptTemplateEngine(PromptTemplateEngine promptTemplateEngine) {
            Verify.notNull((Object)promptTemplateEngine);
            this.promptTemplateEngine = promptTemplateEngine;
            return this;
        }

        public Kernel.Builder withMemoryStorage(MemoryStore storage) {
            Verify.notNull((Object)storage);
            this.memoryStorageFactory = () -> storage;
            return this;
        }

        public Kernel.Builder withMemoryStorage(Supplier<MemoryStore> factory) {
            Verify.notNull(factory);
            this.memoryStorageFactory = factory::get;
            return this;
        }

        public <T extends AIService> Kernel.Builder withDefaultAIService(T instance) {
            Class<?> clazz = instance.getClass();
            this.aiServices.setService(instance, clazz);
            return this;
        }

        public <T extends AIService> Kernel.Builder withDefaultAIService(T instance, Class<T> clazz) {
            this.aiServices.setService(instance, clazz);
            return this;
        }

        public <T extends AIService> Kernel.Builder withDefaultAIService(Supplier<T> factory, Class<T> clazz) {
            this.aiServices.setService(factory, clazz);
            return this;
        }

        public <T extends AIService> Kernel.Builder withAIService(@Nullable String serviceId, T instance, boolean setAsDefault, Class<T> clazz) {
            this.aiServices.setService(serviceId, instance, setAsDefault, clazz);
            return this;
        }

        public <T extends AIService> Kernel.Builder withAIServiceFactory(@Nullable String serviceId, Function<KernelConfig, T> factory, boolean setAsDefault, Class<T> clazz) {
            this.aiServices.setService(serviceId, () -> (AIService)factory.apply(this.config), setAsDefault, clazz);
            return this;
        }

        public Kernel.Builder withMemory(SemanticTextMemory memory) {
            Verify.notNull((Object)memory);
            this.memoryFactory = () -> memory;
            return this;
        }

        public Kernel.Builder withMemoryStorageAndTextEmbeddingGeneration(MemoryStore storage, TextEmbeddingGeneration embeddingGenerator) {
            Verify.notNull((Object)storage);
            Verify.notNull((Object)embeddingGenerator);
            this.memoryFactory = () -> (SemanticTextMemory)SKBuilders.semanticTextMemory().withEmbeddingGenerator((EmbeddingGeneration)embeddingGenerator).withStorage(storage).build();
            return this;
        }

        public Kernel build() {
            if (this.config == null) {
                this.config = SKBuilders.kernelConfig().build();
            }
            return this.build(this.config, this.promptTemplateEngine, this.memoryFactory.get(), this.memoryStorageFactory == null ? null : this.memoryStorageFactory.get(), this.aiServices.build());
        }

        private Kernel build(KernelConfig kernelConfig, @Nullable PromptTemplateEngine promptTemplateEngine, @Nullable SemanticTextMemory memory, @Nullable MemoryStore memoryStore, @Nullable AIServiceProvider aiServiceProvider) {
            if (promptTemplateEngine == null) {
                promptTemplateEngine = new DefaultPromptTemplateEngine();
            }
            if (kernelConfig == null) {
                throw new AIException(AIException.ErrorCodes.INVALID_CONFIGURATION, "It is required to set a kernelConfig to build a kernel");
            }
            DefaultKernel kernel = new DefaultKernel(kernelConfig, promptTemplateEngine, memory, aiServiceProvider);
            if (memoryStore != null) {
                MemoryConfiguration.useMemory(kernel, memoryStore, null);
            }
            return kernel;
        }
    }
}

