/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.connectors.memory.azurecognitivesearch;

import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.rest.Response;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.MetricsOptions;
import com.azure.core.util.TracingOptions;
import com.azure.search.documents.SearchAsyncClient;
import com.azure.search.documents.SearchDocument;
import com.azure.search.documents.indexes.SearchIndexAsyncClient;
import com.azure.search.documents.indexes.SearchIndexClientBuilder;
import com.azure.search.documents.indexes.models.HnswParameters;
import com.azure.search.documents.indexes.models.HnswVectorSearchAlgorithmConfiguration;
import com.azure.search.documents.indexes.models.LexicalAnalyzerName;
import com.azure.search.documents.indexes.models.SearchField;
import com.azure.search.documents.indexes.models.SearchFieldDataType;
import com.azure.search.documents.indexes.models.SearchIndex;
import com.azure.search.documents.indexes.models.VectorSearch;
import com.azure.search.documents.indexes.models.VectorSearchAlgorithmMetric;
import com.azure.search.documents.models.IndexDocumentsOptions;
import com.azure.search.documents.models.IndexDocumentsResult;
import com.azure.search.documents.models.IndexingResult;
import com.azure.search.documents.models.SearchOptions;
import com.azure.search.documents.models.SearchQueryVector;
import com.microsoft.semantickernel.ai.embeddings.Embedding;
import com.microsoft.semantickernel.connectors.memory.azurecognitivesearch.AzureCognitiveSearchMemoryException;
import com.microsoft.semantickernel.connectors.memory.azurecognitivesearch.AzureCognitiveSearchMemoryRecord;
import com.microsoft.semantickernel.memory.MemoryRecord;
import com.microsoft.semantickernel.memory.MemoryStore;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class AzureCognitiveSearchMemoryStore
implements MemoryStore {
    private static final String USER_AGENT = "Semantic-Kernel";
    private static final String SEARCH_CONFIG_NAME = "searchConfig";
    private final SearchIndexAsyncClient _adminClient;
    private final Map<String, SearchAsyncClient> _clientsByIndex = new ConcurrentHashMap<String, SearchAsyncClient>();
    private static final String whitespace = " |\\t|\\n|\\x0B|\\f|\\r";
    private static final String s_replaceIndexNameSymbolsRegex = "[ |\\t|\\n|\\x0B|\\f|\\r|\\|/|.|_|:]";

    public AzureCognitiveSearchMemoryStore(@Nonnull String endpoint, @Nonnull String apiKey) {
        this(new SearchIndexClientBuilder().endpoint(endpoint).credential(new AzureKeyCredential(apiKey)).clientOptions(AzureCognitiveSearchMemoryStore.clientOptions()).buildAsyncClient());
    }

    public AzureCognitiveSearchMemoryStore(@Nonnull String endpoint, @Nonnull TokenCredential credentials) {
        this(new SearchIndexClientBuilder().endpoint(endpoint).credential(credentials).clientOptions(AzureCognitiveSearchMemoryStore.clientOptions()).buildAsyncClient());
    }

    public AzureCognitiveSearchMemoryStore(@Nonnull SearchIndexAsyncClient searchIndexAsyncClient) {
        this._adminClient = searchIndexAsyncClient;
    }

    public Mono<Void> createCollectionAsync(@Nonnull String collectionName) {
        return Mono.empty();
    }

    public Mono<List<String>> getCollectionsAsync() {
        return this.getIndexesAsync();
    }

    public Mono<Boolean> doesCollectionExistAsync(@Nonnull String collectionName) {
        String normalizedIndexName = AzureCognitiveSearchMemoryStore.normalizeIndexName(collectionName);
        return this.getIndexesAsync().map(list -> list.stream().anyMatch(name -> name.equalsIgnoreCase(collectionName) || name.equalsIgnoreCase(normalizedIndexName)));
    }

    public Mono<Void> deleteCollectionAsync(@Nonnull String collectionName) {
        collectionName = AzureCognitiveSearchMemoryStore.normalizeIndexName(collectionName);
        return this._adminClient.deleteIndex(collectionName);
    }

    public Mono<String> upsertAsync(@Nonnull String collectionName, @Nonnull MemoryRecord record) {
        collectionName = AzureCognitiveSearchMemoryStore.normalizeIndexName(collectionName);
        return this.upsertRecordAsync(collectionName, AzureCognitiveSearchMemoryRecord.fromMemoryRecord(record));
    }

    public Mono<Collection<String>> upsertBatchAsync(@Nonnull String collectionName, Collection<MemoryRecord> records) {
        if (records == null || records.isEmpty()) {
            return Mono.just(Collections.emptyList());
        }
        collectionName = AzureCognitiveSearchMemoryStore.normalizeIndexName(collectionName);
        List<AzureCognitiveSearchMemoryRecord> searchRecords = records.stream().map(AzureCognitiveSearchMemoryRecord::fromMemoryRecord).collect(Collectors.toList());
        return this.upsertBatchAsync(collectionName, searchRecords);
    }

    public Mono<MemoryRecord> getAsync(@Nonnull String collectionName, @Nonnull String key, boolean withEmbedding) {
        collectionName = AzureCognitiveSearchMemoryStore.normalizeIndexName(collectionName);
        key = AzureCognitiveSearchMemoryRecord.encodeId(key);
        SearchAsyncClient client = this.getSearchClient(collectionName);
        return client.getDocumentWithResponse(key, AzureCognitiveSearchMemoryRecord.class, null).map(response -> {
            if (response.getStatusCode() == 404) {
                throw new AzureCognitiveSearchMemoryException(AzureCognitiveSearchMemoryException.ErrorCodes.READ_FAILURE, "Index not found");
            }
            return ((AzureCognitiveSearchMemoryRecord)response.getValue()).toMemoryRecord(withEmbedding);
        });
    }

    public Mono<Collection<MemoryRecord>> getBatchAsync(@Nonnull String collectionName, @Nonnull Collection<String> keys, boolean withEmbedding) {
        return Flux.fromIterable(keys).flatMap(key -> this.getAsync(collectionName, (String)key, withEmbedding)).collect(Collectors.toList());
    }

    public Mono<Tuple2<MemoryRecord, Float>> getNearestMatchAsync(@Nonnull String collectionName, @Nonnull Embedding embedding, float minRelevanceScore, boolean withEmbedding) {
        return this.getNearestMatchesAsync(collectionName, embedding, 1, minRelevanceScore, withEmbedding).map(matches -> (Tuple2)matches.iterator().next());
    }

    public Mono<Collection<Tuple2<MemoryRecord, Float>>> getNearestMatchesAsync(@Nonnull String collectionName, @Nonnull Embedding embedding, int limit, float minRelevanceScore, boolean withEmbedding) {
        collectionName = AzureCognitiveSearchMemoryStore.normalizeIndexName(collectionName);
        SearchAsyncClient client = this.getSearchClient(collectionName);
        SearchQueryVector searchVector = new SearchQueryVector().setKNearestNeighborsCount(Integer.valueOf(limit)).setFields(new String[]{"Embedding"}).setValue(embedding.getVector());
        SearchOptions searchOptions = new SearchOptions().setVectors(new SearchQueryVector[]{searchVector});
        return client.search(null, searchOptions).filter(result -> (double)minRelevanceScore >= result.getScore()).map(result -> {
            MemoryRecord memoryRecord = ((AzureCognitiveSearchMemoryRecord)result.getDocument(AzureCognitiveSearchMemoryRecord.class)).toMemoryRecord(withEmbedding);
            float score = (float)result.getScore();
            return Tuples.of((Object)memoryRecord, (Object)Float.valueOf(score));
        }).collect(Collectors.toList());
    }

    public Mono<Void> removeAsync(@Nonnull String collectionName, @Nonnull String key) {
        return this.removeBatchAsync(collectionName, Collections.singleton(key));
    }

    public Mono<Void> removeBatchAsync(@Nonnull String collectionName, @Nonnull Collection<String> keys) {
        collectionName = AzureCognitiveSearchMemoryStore.normalizeIndexName(collectionName);
        SearchAsyncClient client = this.getSearchClient(collectionName);
        List documents = keys.stream().map(AzureCognitiveSearchMemoryRecord::encodeId).map(key -> {
            SearchDocument searchDocument = new SearchDocument();
            searchDocument.put((Object)"Id", key);
            return searchDocument;
        }).collect(Collectors.toList());
        return client.deleteDocuments(documents).then();
    }

    static List<SearchField> searchFields(String configName, int embeddingSize) {
        return Arrays.asList(new SearchField("Id", SearchFieldDataType.STRING).setKey(Boolean.valueOf(true)).setFilterable(Boolean.valueOf(false)), new SearchField("Embedding", SearchFieldDataType.collection((SearchFieldDataType)SearchFieldDataType.SINGLE)).setSearchable(Boolean.valueOf(true)).setVectorSearchDimensions(Integer.valueOf(embeddingSize)).setVectorSearchConfiguration(configName), new SearchField("Text", SearchFieldDataType.STRING).setSearchable(Boolean.valueOf(true)).setFacetable(Boolean.valueOf(true)).setAnalyzerName(LexicalAnalyzerName.EN_LUCENE), new SearchField("Description", SearchFieldDataType.STRING).setSearchable(Boolean.valueOf(true)).setFacetable(Boolean.valueOf(true)).setAnalyzerName(LexicalAnalyzerName.EN_LUCENE), new SearchField("AdditionalMetadata", SearchFieldDataType.STRING).setSearchable(Boolean.valueOf(true)).setFacetable(Boolean.valueOf(true)).setAnalyzerName(LexicalAnalyzerName.EN_LUCENE), new SearchField("ExternalSourceName", SearchFieldDataType.STRING).setSearchable(Boolean.valueOf(true)).setFacetable(Boolean.valueOf(true)).setAnalyzerName(LexicalAnalyzerName.EN_LUCENE), new SearchField("Reference", SearchFieldDataType.BOOLEAN).setFilterable(Boolean.valueOf(true)).setFacetable(Boolean.valueOf(true)));
    }

    private Mono<Response<SearchIndex>> createIndexAsync(@Nonnull String indexName, int embeddingSize) {
        if (embeddingSize < 1) {
            throw new AzureCognitiveSearchMemoryException(AzureCognitiveSearchMemoryException.ErrorCodes.INVALID_EMBEDDING_SIZE, "the value must be greater than zero");
        }
        String normalizedIndexName = AzureCognitiveSearchMemoryStore.normalizeIndexName(indexName);
        VectorSearch vectorSearch = new VectorSearch().setAlgorithmConfigurations(Collections.singletonList(new HnswVectorSearchAlgorithmConfiguration(SEARCH_CONFIG_NAME).setParameters(new HnswParameters().setMetric(VectorSearchAlgorithmMetric.COSINE))));
        SearchIndex newIndex = new SearchIndex(normalizedIndexName).setFields(AzureCognitiveSearchMemoryStore.searchFields(SEARCH_CONFIG_NAME, embeddingSize)).setVectorSearch(vectorSearch);
        return this._adminClient.createIndexWithResponse(newIndex);
    }

    private Mono<List<String>> getIndexesAsync() {
        return this._adminClient.listIndexes().map(SearchIndex::getName).collect(Collectors.toList());
    }

    private Mono<String> upsertRecordAsync(@Nonnull String indexName, @Nonnull AzureCognitiveSearchMemoryRecord record) {
        return this.upsertBatchAsync(indexName, Collections.singletonList(record)).map(Collection::iterator).map(Iterator::next);
    }

    private Mono<Collection<String>> upsertBatchAsync(@Nonnull String indexName, @Nonnull List<AzureCognitiveSearchMemoryRecord> records) {
        if (records.isEmpty()) {
            return Mono.just(Collections.emptyList());
        }
        List documents = records.stream().map(record -> {
            SearchDocument searchDocument = new SearchDocument();
            searchDocument.put((Object)"Id", (Object)AzureCognitiveSearchMemoryRecord.encodeId(record.getId()));
            searchDocument.put((Object)"Text", (Object)record.getText());
            searchDocument.put((Object)"Description", (Object)record.getDescription());
            searchDocument.put((Object)"Embedding", record.getEmbedding());
            searchDocument.put((Object)"AdditionalMetadata", (Object)record.getAdditionalMetadata());
            searchDocument.put((Object)"ExternalSourceName", (Object)record.getExternalSourceName());
            searchDocument.put((Object)"Reference", (Object)record.isReference());
            return searchDocument;
        }).collect(Collectors.toList());
        IndexDocumentsOptions options = new IndexDocumentsOptions().setThrowOnAnyError(true);
        int embeddingSize = records.stream().map(AzureCognitiveSearchMemoryRecord::getEmbedding).map(List::size).max(Integer::compareTo).orElse(0);
        String normalizedIndexName = AzureCognitiveSearchMemoryStore.normalizeIndexName(indexName);
        SearchAsyncClient client = this.getSearchClient(normalizedIndexName);
        return client.uploadDocumentsWithResponse(documents, options).map(response -> {
            if (response.getStatusCode() == 404) {
                throw new AzureCognitiveSearchMemoryException(AzureCognitiveSearchMemoryException.ErrorCodes.INVALID_INDEX_NAME);
            }
            return response;
        }).onErrorResume(e -> this.createIndexAsync(normalizedIndexName, embeddingSize).then(client.uploadDocumentsWithResponse((Iterable)documents, options))).map(response -> ((IndexDocumentsResult)response.getValue()).getResults().stream().map(IndexingResult::getKey).collect(Collectors.toList()));
    }

    private SearchAsyncClient getSearchClient(@Nonnull String indexName) {
        String normalizedIndexName = AzureCognitiveSearchMemoryStore.normalizeIndexName(indexName);
        return this._clientsByIndex.computeIfAbsent(normalizedIndexName, arg_0 -> ((SearchIndexAsyncClient)this._adminClient).getSearchAsyncClient(arg_0));
    }

    private static ClientOptions clientOptions() {
        return new ClientOptions().setTracingOptions(new TracingOptions()).setMetricsOptions(new MetricsOptions()).setApplicationId(USER_AGENT);
    }

    private static String normalizeIndexName(String indexName) {
        if (indexName.length() > 128) {
            throw new IllegalArgumentException("The collection name cannot exceed 128 chars");
        }
        indexName = indexName.toLowerCase(Locale.ROOT);
        return indexName.replaceAll(s_replaceIndexNameSymbolsRegex, "-");
    }
}

