/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.connectors.memory.azurecognitivesearch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.semantickernel.ai.embeddings.Embedding;
import com.microsoft.semantickernel.memory.MemoryRecord;
import com.microsoft.semantickernel.memory.MemoryRecordMetadata;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public final class AzureCognitiveSearchMemoryRecord {
    static final String ID = "Id";
    static final String TEXT = "Text";
    static final String DESCRIPTION = "Description";
    static final String ADDITIONAL_METADATA = "AdditionalMetadata";
    static final String EMBEDDING = "Embedding";
    static final String EXTERNAL_SOURCE_NAME = "ExternalSourceName";
    static final String IS_REFERENCE = "Reference";
    private final String id;
    private final String text;
    private final String description;
    private final String additionalMetadata;
    private final List<Float> embedding;
    private final String externalSourceName;
    private final boolean isReference;

    @JsonCreator
    public AzureCognitiveSearchMemoryRecord(@JsonProperty(value="Id") String id, @JsonProperty(value="Text") String text, @JsonProperty(value="Description") String description, @JsonProperty(value="AdditionalMetadata") String additionalMetadata, @JsonProperty(value="Embedding") List<Float> embedding, @JsonProperty(value="ExternalSourceName") String externalSourceName, @JsonProperty(value="Reference") boolean isReference) {
        this.id = id;
        this.text = text;
        this.description = description;
        this.additionalMetadata = additionalMetadata;
        this.embedding = embedding != null ? embedding : Collections.emptyList();
        this.externalSourceName = externalSourceName;
        this.isReference = isReference;
    }

    public String getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAdditionalMetadata() {
        return this.additionalMetadata;
    }

    public List<Float> getEmbedding() {
        return this.embedding;
    }

    public String getExternalSourceName() {
        return this.externalSourceName;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public MemoryRecordMetadata toMemoryRecordMetadata() {
        return new MemoryRecordMetadata(this.isReference, AzureCognitiveSearchMemoryRecord.decodeId(this.id), this.text, this.description, this.externalSourceName, this.additionalMetadata);
    }

    public static AzureCognitiveSearchMemoryRecord fromMemoryRecord(MemoryRecord record) {
        return new AzureCognitiveSearchMemoryRecord(record.getMetadata().getId(), record.getMetadata().getText(), record.getMetadata().getDescription(), record.getMetadata().getAdditionalMetadata(), record.getEmbedding().getVector(), record.getMetadata().getExternalSourceName(), record.getMetadata().isReference());
    }

    public MemoryRecord toMemoryRecord() {
        return this.toMemoryRecord(true);
    }

    public MemoryRecord toMemoryRecord(boolean withEmbeddings) {
        return new MemoryRecord(this.toMemoryRecordMetadata(), new Embedding(withEmbeddings ? this.embedding : Collections.emptyList()), this.id, null);
    }

    static String encodeId(@Nullable String realId) {
        if (realId == null) {
            return "";
        }
        byte[] bytes = Base64.getUrlEncoder().encode(realId.getBytes(StandardCharsets.UTF_8));
        return new String(bytes, StandardCharsets.UTF_8);
    }

    static String decodeId(@Nullable String encodedId) {
        if (encodedId == null) {
            return "";
        }
        byte[] bytes = Base64.getUrlDecoder().decode(encodedId.getBytes(StandardCharsets.UTF_8));
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

