/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.connectors.ai.openai.textembeddings;

import com.azure.ai.openai.OpenAIAsyncClient;
import com.azure.ai.openai.models.EmbeddingItem;
import com.azure.ai.openai.models.Embeddings;
import com.azure.ai.openai.models.EmbeddingsOptions;
import com.microsoft.semantickernel.ai.embeddings.Embedding;
import com.microsoft.semantickernel.ai.embeddings.TextEmbeddingGeneration;
import com.microsoft.semantickernel.connectors.ai.openai.azuresdk.ClientBase;
import com.microsoft.semantickernel.exceptions.NotSupportedException;
import java.util.List;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class OpenAITextEmbeddingGeneration
extends ClientBase
implements TextEmbeddingGeneration {
    public OpenAITextEmbeddingGeneration(OpenAIAsyncClient client, String modelId) {
        super(client, modelId);
    }

    public Mono<List<Embedding>> generateEmbeddingsAsync(List<String> data) {
        return this.internalGenerateTextEmbeddingsAsync(data);
    }

    protected Mono<List<Embedding>> internalGenerateTextEmbeddingsAsync(List<String> data) {
        EmbeddingsOptions options = new EmbeddingsOptions(data).setModel(this.getModelId()).setUser("default");
        return this.getClient().getEmbeddings(this.getModelId(), options).flatMapIterable(Embeddings::getData).mapNotNull(EmbeddingItem::getEmbedding).map(embedding -> embedding.stream().map(Double::floatValue).collect(Collectors.toList())).mapNotNull(Embedding::new).collectList();
    }

    public static class Builder
    implements TextEmbeddingGeneration.Builder {
        private OpenAIAsyncClient client;
        private String modelId;

        public Builder withOpenAIClient(OpenAIAsyncClient client) {
            this.client = client;
            return this;
        }

        public Builder withModelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public OpenAITextEmbeddingGeneration build() {
            if (this.client == null) {
                throw new NotSupportedException(NotSupportedException.ErrorCodes.NOT_SUPPORTED, "OpenAI client not set");
            }
            if (this.modelId == null) {
                throw new NotSupportedException(NotSupportedException.ErrorCodes.NOT_SUPPORTED, "Model ID not set");
            }
            return new OpenAITextEmbeddingGeneration(this.client, this.modelId);
        }
    }
}

