/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.connectors.ai.openai.chatcompletion;

import com.azure.ai.openai.OpenAIAsyncClient;
import com.azure.ai.openai.models.ChatChoice;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.ChatMessage;
import com.azure.ai.openai.models.ChatRole;
import com.microsoft.semantickernel.Verify;
import com.microsoft.semantickernel.ai.AIException;
import com.microsoft.semantickernel.chatcompletion.ChatCompletion;
import com.microsoft.semantickernel.chatcompletion.ChatHistory;
import com.microsoft.semantickernel.chatcompletion.ChatRequestSettings;
import com.microsoft.semantickernel.connectors.ai.openai.azuresdk.ClientBase;
import com.microsoft.semantickernel.connectors.ai.openai.chatcompletion.OpenAIChatHistory;
import com.microsoft.semantickernel.exceptions.NotSupportedException;
import com.microsoft.semantickernel.textcompletion.CompletionRequestSettings;
import com.microsoft.semantickernel.textcompletion.CompletionType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class OpenAIChatCompletion
extends ClientBase
implements ChatCompletion<OpenAIChatHistory> {
    public OpenAIChatCompletion(OpenAIAsyncClient client, String modelId) {
        super(client, modelId);
    }

    public Mono<List<String>> completeAsync(@Nonnull String text, @Nonnull CompletionRequestSettings requestSettings) {
        ChatRequestSettings chatRequestSettings = new ChatRequestSettings(requestSettings);
        return this.generateMessageAsync(this.createNewChat(text), chatRequestSettings).map(xva$0 -> Arrays.asList(xva$0));
    }

    public Flux<String> completeStreamAsync(@Nonnull String text, @Nonnull CompletionRequestSettings requestSettings) {
        ChatRequestSettings chatRequestSettings = new ChatRequestSettings(requestSettings);
        return this.generateMessageStream(this.createNewChat(text), chatRequestSettings);
    }

    public CompletionType defaultCompletionType() {
        return CompletionType.STREAMING;
    }

    public Mono<String> generateMessageAsync(OpenAIChatHistory chat, @Nullable ChatRequestSettings requestSettings) {
        if (requestSettings == null) {
            requestSettings = new ChatRequestSettings();
        }
        return this.internalGenerateChatMessageAsync(chat, requestSettings);
    }

    private Mono<String> internalGenerateChatMessageAsync(ChatHistory chat, ChatRequestSettings requestSettings) {
        Verify.notNull((Object)chat);
        Verify.notNull((Object)requestSettings);
        OpenAIChatCompletion.validateMaxTokens(requestSettings.getMaxTokens());
        ChatCompletionsOptions options = OpenAIChatCompletion.createChatCompletionsOptions(requestSettings, chat);
        return this.getClient().getChatCompletions(this.getModelId(), options).flatMap(response -> {
            if (response == null || response.getChoices().isEmpty()) {
                return Mono.error((Throwable)new AIException(AIException.ErrorCodes.INVALID_RESPONSE_CONTENT, "Chat completions not found"));
            }
            return Mono.just((Object)((ChatChoice)response.getChoices().get(0)).getMessage().getContent());
        });
    }

    private static ChatCompletionsOptions createChatCompletionsOptions(ChatRequestSettings requestSettings, ChatHistory chat) {
        List messages = chat.getMessages().stream().map(it -> new ChatMessage(OpenAIChatCompletion.toChatRole(it.getAuthorRoles())).setContent(it.getContent())).collect(Collectors.toList());
        ChatCompletionsOptions options = new ChatCompletionsOptions(messages);
        options.setMaxTokens(Integer.valueOf(requestSettings.getMaxTokens()));
        options.setTemperature(Double.valueOf(requestSettings.getTemperature()));
        options.setTopP(Double.valueOf(requestSettings.getTopP()));
        options.setFrequencyPenalty(Double.valueOf(requestSettings.getFrequencyPenalty()));
        options.setPresencePenalty(Double.valueOf(requestSettings.getPresencePenalty()));
        options.setLogitBias(new HashMap());
        options.setN(requestSettings.getBestOf());
        options.setUser(requestSettings.getUser());
        options.setStop(requestSettings.getStopSequences());
        return options;
    }

    private static ChatRole toChatRole(ChatHistory.AuthorRoles authorRoles) {
        switch (authorRoles) {
            case System: {
                return ChatRole.SYSTEM;
            }
            case User: {
                return ChatRole.USER;
            }
            case Assistant: {
                return ChatRole.ASSISTANT;
            }
        }
        throw new IllegalArgumentException("Invalid chat message author: " + authorRoles.name());
    }

    public OpenAIChatHistory createNewChat(@Nullable String instructions) {
        return OpenAIChatCompletion.internalCreateNewChat(instructions);
    }

    public Flux<String> generateMessageStream(OpenAIChatHistory chat, @Nullable ChatRequestSettings requestSettings) {
        return this.getStreamingChatCompletionsAsync(chat, requestSettings).groupBy(ChatCompletions::getId).concatMap(chatCompletionResult -> chatCompletionResult.concatMap(chatCompletions -> Flux.fromIterable((Iterable)chatCompletions.getChoices())).reduce((Object)"", OpenAIChatCompletion.accumulateString()));
    }

    private static BiFunction<String, ChatChoice, String> accumulateString() {
        return (newString, chatChoice) -> {
            ChatMessage message = chatChoice.getDelta();
            if (message != null && message.getContent() != null) {
                return newString + message.getContent();
            }
            return newString;
        };
    }

    public Flux<ChatCompletions> getStreamingChatCompletionsAsync(OpenAIChatHistory chat, ChatRequestSettings requestSettings) {
        return this.internalGetChatStreamingResultsAsync(chat, requestSettings);
    }

    private Flux<ChatCompletions> internalGetChatStreamingResultsAsync(ChatHistory chat, @Nullable ChatRequestSettings requestSettings) {
        Verify.notNull((Object)chat);
        if (requestSettings == null) {
            requestSettings = new ChatRequestSettings();
        }
        ClientBase.validateMaxTokens(requestSettings.getMaxTokens());
        ChatCompletionsOptions options = OpenAIChatCompletion.createChatCompletionsOptions(requestSettings, chat);
        options = options.setStream(Boolean.valueOf(true));
        return this.getClient().getChatCompletionsStream(this.getModelId(), options);
    }

    private static OpenAIChatHistory internalCreateNewChat(@Nullable String instructions) {
        if (instructions == null) {
            instructions = "";
        }
        OpenAIChatHistory history = new OpenAIChatHistory("Assistant is a large language model.");
        history.addUserMessage(instructions);
        return history;
    }

    public static class Builder
    implements ChatCompletion.Builder<OpenAIChatHistory> {
        @Nullable
        private OpenAIAsyncClient client;
        @Nullable
        private String modelId;

        public Builder withOpenAIClient(OpenAIAsyncClient client) {
            this.client = client;
            return this;
        }

        public Builder withModelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public ChatCompletion build() {
            if (this.client == null) {
                throw new NotSupportedException(NotSupportedException.ErrorCodes.NOT_SUPPORTED, "OpenAI client not set");
            }
            if (this.modelId == null) {
                throw new NotSupportedException(NotSupportedException.ErrorCodes.NOT_SUPPORTED, "Model ID not set");
            }
            return new OpenAIChatCompletion(this.client, this.modelId);
        }
    }
}

