/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.services;

import com.microsoft.semantickernel.Verify;
import com.microsoft.semantickernel.services.AIServiceCollection;
import com.microsoft.semantickernel.services.NamedServiceProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class DefaultNamedServiceProvider<T>
implements NamedServiceProvider<T> {
    private final Map<Class<? extends T>, Map<String, Supplier<? extends T>>> services;
    private final Map<Class<? extends T>, String> defaultIds;

    public DefaultNamedServiceProvider(Map<Class<? extends T>, Map<String, Supplier<? extends T>>> services, Map<Class<? extends T>, String> defaultIds) {
        this.services = AIServiceCollection.cloneServices(services);
        this.defaultIds = new HashMap<Class<T>, String>(defaultIds);
    }

    @Override
    @Nullable
    public <U extends T> U getService(@Nullable String name, Class<U> clazz) {
        Supplier<U> factory = this.getServiceFactory(name, clazz);
        if (factory != null) {
            return factory.get();
        }
        return null;
    }

    @Nullable
    private <U extends T> String getDefaultServiceName(Class<U> clazz) {
        String name = this.defaultIds.get(clazz);
        if (!Verify.isNullOrEmpty(name)) {
            return name;
        }
        return null;
    }

    @Nullable
    private <U extends T> Supplier<U> getServiceFactory(@Nullable String name, Class<U> clazz) {
        Map<String, Supplier<T>> namedServices = this.services.get(clazz);
        if (namedServices != null) {
            Supplier<? extends T> serviceFactory = null;
            String string = name = name == null ? this.getDefaultServiceName(clazz) : name;
            if (name != null) {
                serviceFactory = namedServices.get(name);
            }
            return serviceFactory;
        }
        return null;
    }
}

