/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.orchestration;

import com.microsoft.semantickernel.SKBuilders;
import com.microsoft.semantickernel.memory.NullMemory;
import com.microsoft.semantickernel.memory.SemanticTextMemory;
import com.microsoft.semantickernel.orchestration.ContextVariables;
import com.microsoft.semantickernel.orchestration.FunctionNotRegisteredException;
import com.microsoft.semantickernel.orchestration.RegistrableSkFunction;
import com.microsoft.semantickernel.orchestration.SKContext;
import com.microsoft.semantickernel.orchestration.SKFunction;
import com.microsoft.semantickernel.skilldefinition.KernelSkillsSupplier;
import com.microsoft.semantickernel.skilldefinition.ParameterView;
import com.microsoft.semantickernel.skilldefinition.ReadOnlySkillCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import reactor.core.publisher.Mono;

public abstract class AbstractSkFunction<RequestConfiguration>
implements SKFunction<RequestConfiguration>,
RegistrableSkFunction {
    private final List<ParameterView> parameters;
    private final String skillName;
    private final String functionName;
    private final String description;
    private final List<ParameterView> returnParameters;
    @Nullable
    private KernelSkillsSupplier skillsSupplier;

    public AbstractSkFunction(List<ParameterView> parameters, String skillName, String functionName, String description, List<ParameterView> returnParameters, @Nullable KernelSkillsSupplier skillsSupplier) {
        this.parameters = new ArrayList<ParameterView>(parameters);
        this.skillName = skillName;
        this.functionName = functionName;
        this.description = description;
        this.returnParameters = Collections.unmodifiableList(returnParameters);
        this.skillsSupplier = skillsSupplier;
    }

    protected void assertSkillSupplierRegistered() {
        if (this.skillsSupplier == null) {
            throw new FunctionNotRegisteredException(FunctionNotRegisteredException.ErrorCodes.FUNCTION_NOT_REGISTERED, this.getName());
        }
    }

    protected void setSkillsSupplier(@Nullable KernelSkillsSupplier skillsSupplier) {
        this.skillsSupplier = skillsSupplier;
    }

    @Nullable
    public KernelSkillsSupplier getSkillsSupplier() {
        return this.skillsSupplier;
    }

    @Override
    public Mono<SKContext> invokeAsync(@Nullable String input, @Nullable SKContext context, @Nullable RequestConfiguration settings) {
        if (context == null) {
            this.assertSkillSupplierRegistered();
            context = (SKContext)SKBuilders.context().withMemory(NullMemory.getInstance()).withSkills(this.skillsSupplier == null ? null : (ReadOnlySkillCollection)this.skillsSupplier.get()).build();
        } else {
            context = context.copy();
        }
        if (input != null) {
            context = context.update(input);
        }
        return this.invokeAsync(context, settings);
    }

    @Override
    public Mono<SKContext> invokeAsync(String input) {
        return this.invokeAsync(input, null, null);
    }

    @Override
    public Mono<SKContext> invokeAsync(@Nullable SKContext context, @Nullable RequestConfiguration settings) {
        context = context == null ? (SKContext)SKBuilders.context().withVariables((ContextVariables)SKBuilders.variables().build()).withMemory(NullMemory.getInstance()).build() : context.copy();
        return this.invokeAsyncInternal(context, settings);
    }

    protected abstract Mono<SKContext> invokeAsyncInternal(SKContext var1, @Nullable RequestConfiguration var2);

    @Override
    public String getSkillName() {
        return this.skillName;
    }

    @Override
    public String getName() {
        return this.functionName;
    }

    public List<ParameterView> getParametersView() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public String toFullyQualifiedName() {
        return this.skillName + "." + this.functionName;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    public String toEmbeddingString() {
        String inputs = this.parameters.stream().map(p -> "    - " + p.getName() + ": " + p.getDescription()).collect(Collectors.joining("\n"));
        return this.getName() + ":\n  description: " + this.getDescription() + "\n  inputs:\n" + inputs;
    }

    @Override
    public String toManualString(boolean includeOutputs) {
        String inputs = this.parameters.stream().map(parameter -> {
            String defaultValueString = parameter.getDefaultValue() == null || parameter.getDefaultValue().isEmpty() || parameter.getDefaultValue().equals("SKFunctionParameters__NO_INPUT_PROVIDED") ? "" : " (default value: " + parameter.getDefaultValue() + ")";
            return "  - " + parameter.getName() + ": " + parameter.getDescription() + defaultValueString;
        }).map(s -> s.toLowerCase(Locale.ROOT)).sorted().distinct().collect(Collectors.joining("\n"));
        String outputsList = "";
        if (this.returnParameters.size() > 0) {
            outputsList = this.returnParameters.stream().filter(it -> !it.getDescription().isEmpty()).map(it -> "  - " + it.getName() + ": " + it.getDescription()).collect(Collectors.joining("\n"));
        }
        String outputs = "";
        if (includeOutputs) {
            outputs = "\n  outputs:\n";
            outputs = outputsList.length() > 0 ? outputs + outputsList : outputs + "  - return: void";
        }
        return this.toFullyQualifiedName() + ":\n  description: " + this.getDescription() + "\n  inputs:\n" + inputs + outputs;
    }

    @Override
    public Mono<SKContext> invokeWithCustomInputAsync(ContextVariables variables, @Nullable SemanticTextMemory semanticMemory, @Nullable ReadOnlySkillCollection skills) {
        SKContext tmpContext = (SKContext)SKBuilders.context().withVariables(variables).withMemory(semanticMemory).withSkills(skills).build();
        return this.invokeAsync(tmpContext, null);
    }

    @Override
    public Mono<SKContext> invokeAsync() {
        return this.invokeAsync(null, null, null);
    }

    @Override
    public Mono<SKContext> invokeAsync(SKContext context) {
        return this.invokeAsync(context, null);
    }
}

