/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.policy;

import com.microsoft.rest.v2.http.HttpRequest;
import com.microsoft.rest.v2.http.HttpResponse;
import com.microsoft.rest.v2.policy.RequestPolicy;
import com.microsoft.rest.v2.policy.RequestPolicyFactory;
import com.microsoft.rest.v2.policy.RequestPolicyOptions;
import com.microsoft.rest.v2.protocol.HttpResponseDecoder;
import io.reactivex.Single;

public final class DecodingPolicyFactory
implements RequestPolicyFactory {
    @Override
    public RequestPolicy create(RequestPolicy next, RequestPolicyOptions options) {
        return new DecodingPolicy(next);
    }

    private final class DecodingPolicy
    implements RequestPolicy {
        private final RequestPolicy next;

        private DecodingPolicy(RequestPolicy next) {
            this.next = next;
        }

        @Override
        public Single<HttpResponse> sendAsync(HttpRequest request) {
            return this.next.sendAsync(request).flatMap(response -> {
                HttpResponseDecoder decoder = request.responseDecoder();
                if (decoder != null) {
                    return request.responseDecoder().decode((HttpResponse)response);
                }
                return Single.error((Throwable)new NullPointerException("HttpRequest.responseDecoder() was null when decoding."));
            });
        }
    }
}

