/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.interceptors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.io.CharStreams;
import com.microsoft.rest.LogLevel;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInterceptor
implements Interceptor {
    private static final String LOGGING_HEADER = "x-ms-logging-context";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private LogLevel logLevel;

    public LoggingInterceptor(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    protected void log(Logger logger, String s) {
        logger.info(s);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        String bodySize;
        Response response;
        Request request = chain.request();
        String context = request.header(LOGGING_HEADER);
        if (context == null) {
            context = "";
        }
        Logger logger = LoggerFactory.getLogger((String)context);
        if (this.logLevel != LogLevel.NONE) {
            this.log(logger, String.format("--> %s %s", request.method(), request.url()));
        }
        if (this.logLevel == LogLevel.HEADERS || this.logLevel == LogLevel.BODY_AND_HEADERS) {
            for (String header : request.headers().names()) {
                if (LOGGING_HEADER.equals(header)) continue;
                this.log(logger, String.format("%s: %s", header, Joiner.on((String)", ").join((Iterable)request.headers(header))));
            }
        }
        if ((this.logLevel == LogLevel.BODY || this.logLevel == LogLevel.BODY_AND_HEADERS) && request.body() != null) {
            Buffer buffer = new Buffer();
            request.body().writeTo((BufferedSink)buffer);
            Charset charset = Charset.forName("UTF8");
            MediaType contentType = request.body().contentType();
            if (contentType != null) {
                charset = contentType.charset(charset);
            }
            if (LoggingInterceptor.isPlaintext(buffer)) {
                String content = buffer.clone().readString(charset);
                if (this.logLevel.isPrettyJson()) {
                    try {
                        content = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(MAPPER.readValue(content, JsonNode.class));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.log(logger, String.format("%s-byte body:\n%s", request.body().contentLength(), content));
                this.log(logger, "--> END " + request.method());
            } else {
                this.log(logger, "--> END " + request.method() + " (binary " + request.body().contentLength() + "-byte body omitted)");
            }
        }
        long startNs = System.nanoTime();
        try {
            response = chain.proceed(request);
        }
        catch (Exception e) {
            this.log(logger, "<-- HTTP FAILED: " + e);
            throw e;
        }
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        ResponseBody responseBody = response.body();
        long contentLength = responseBody.contentLength();
        String string = bodySize = contentLength != -1L ? contentLength + "-byte" : "unknown-length";
        if (this.logLevel != LogLevel.NONE) {
            this.log(logger, String.format("<-- %s %s %s (%s ms, %s body)", response.code(), response.message(), response.request().url(), tookMs, bodySize));
        }
        if (this.logLevel == LogLevel.HEADERS || this.logLevel == LogLevel.BODY_AND_HEADERS) {
            for (String header : response.headers().names()) {
                this.log(logger, String.format("%s: %s", header, Joiner.on((String)", ").join((Iterable)response.headers(header))));
            }
        }
        if ((this.logLevel == LogLevel.BODY || this.logLevel == LogLevel.BODY_AND_HEADERS) && response.body() != null) {
            boolean gzipped;
            BufferedSource source = responseBody.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.buffer();
            Charset charset = Charset.forName("UTF8");
            MediaType contentType = responseBody.contentType();
            if (contentType != null) {
                try {
                    charset = contentType.charset(charset);
                }
                catch (UnsupportedCharsetException e) {
                    this.log(logger, "Couldn't decode the response body; charset is likely malformed.");
                    this.log(logger, "<-- END HTTP");
                    return response;
                }
            }
            boolean bl = gzipped = response.header("content-encoding") != null && StringUtils.containsIgnoreCase((CharSequence)response.header("content-encoding"), (CharSequence)"gzip");
            if (!LoggingInterceptor.isPlaintext(buffer) && !gzipped) {
                this.log(logger, "<-- END HTTP (binary " + buffer.size() + "-byte body omitted)");
                return response;
            }
            if (contentLength != 0L) {
                String content = gzipped ? CharStreams.toString((Readable)new InputStreamReader(new GZIPInputStream(buffer.clone().inputStream()))) : buffer.clone().readString(charset);
                if (this.logLevel.isPrettyJson()) {
                    try {
                        content = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(MAPPER.readValue(content, JsonNode.class));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.log(logger, String.format("%s-byte body:\n%s", buffer.size(), content));
            }
            this.log(logger, "<-- END HTTP");
        }
        return response;
    }

    public LogLevel logLevel() {
        return this.logLevel;
    }

    public LoggingInterceptor withLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    private static boolean isPlaintext(Buffer buffer) throws EOFException {
        try {
            Buffer prefix = new Buffer();
            long byteCount = buffer.size() < 64L ? buffer.size() : 64L;
            buffer.copyTo(prefix, 0L, byteCount);
            for (int i = 0; i < 16 && !prefix.exhausted(); ++i) {
                int codePoint = prefix.readUtf8CodePoint();
                if (!Character.isISOControl(codePoint) || Character.isWhitespace(codePoint)) continue;
                return false;
            }
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }
}

