/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.impl.Driver;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.concurrent.TimeUnit;

public class DriverJar
extends Driver {
    private final Path driverTempDir = Files.createTempDirectory("playwright-java-", new FileAttribute[0]);

    DriverJar() throws IOException, URISyntaxException, InterruptedException {
        this.driverTempDir.toFile().deleteOnExit();
        System.err.println("extracting driver to " + this.driverTempDir);
        this.extractDriverToTempDir();
        this.installBrowsers();
    }

    private void installBrowsers() throws IOException, InterruptedException {
        Path driver = this.driverTempDir.resolve("playwright-cli");
        ProcessBuilder pb = new ProcessBuilder(driver.toString(), "install");
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        Process p = pb.start();
        boolean result = p.waitFor(10L, TimeUnit.MINUTES);
        if (!result) {
            System.err.println("Timed out waiting for browsers to install");
        }
    }

    private void extractDriverToTempDir() throws URISyntaxException, IOException {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        URI uri = classloader.getResource("driver/" + DriverJar.platformDir()).toURI();
        System.out.println(uri);
        try (FileSystem fileSystem = "jar".equals(uri.getScheme()) ? FileSystems.newFileSystem(uri, Collections.emptyMap()) : null;){
            Files.list(Paths.get(uri)).forEach(filePath -> {
                try {
                    DriverJar.extractResource(filePath, this.driverTempDir);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to extract driver from " + uri, e);
                }
            });
        }
    }

    private static String platformDir() {
        String name = System.getProperty("os.name").toLowerCase();
        if (name.contains("windows")) {
            return System.getProperty("os.arch").equals("amd64") ? "win32_x64" : "win32";
        }
        if (name.contains("linux")) {
            return "linux";
        }
        if (name.contains("mac os x")) {
            return "mac";
        }
        throw new RuntimeException("Unexpected os.name value: " + name);
    }

    private static Path extractResource(Path from, Path toDir) throws IOException {
        Path path = toDir.resolve(from.getFileName().toString());
        Files.copy(from, path, new CopyOption[0]);
        path.toFile().setExecutable(true);
        path.toFile().deleteOnExit();
        return path;
    }

    Path driverDir() {
        return this.driverTempDir;
    }
}

