/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.serialization;

import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.ValuedEnumParser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Base64;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;

public class TextParseNode
implements ParseNode {
    private final String text;
    private static final String NO_STRUCTURED_DATA_MESSAGE = "text does not support structured data";
    private Consumer<Parsable> onBeforeAssignFieldValues;
    private Consumer<Parsable> onAfterAssignFieldValues;

    public TextParseNode(@Nonnull String rawText) {
        Objects.requireNonNull(rawText, "parameter node cannot be null");
        this.text = rawText.startsWith("\"") && rawText.endsWith("\"") ? rawText.substring(1, rawText.length() - 2) : rawText;
    }

    @Nullable
    public ParseNode getChildNode(@Nonnull String identifier) {
        throw new UnsupportedOperationException(NO_STRUCTURED_DATA_MESSAGE);
    }

    @Nullable
    public String getStringValue() {
        return this.text;
    }

    @Nullable
    public Boolean getBooleanValue() {
        return Boolean.parseBoolean(this.text);
    }

    @Nullable
    public Byte getByteValue() {
        return Byte.parseByte(this.text);
    }

    @Nullable
    public Short getShortValue() {
        return Short.parseShort(this.text);
    }

    @Nullable
    public BigDecimal getBigDecimalValue() {
        return new BigDecimal(this.text);
    }

    @Nullable
    public Integer getIntegerValue() {
        return Integer.parseInt(this.text);
    }

    @Nullable
    public Float getFloatValue() {
        return Float.valueOf(Float.parseFloat(this.text));
    }

    @Nullable
    public Double getDoubleValue() {
        return Double.parseDouble(this.text);
    }

    @Nullable
    public Long getLongValue() {
        return Long.parseLong(this.text);
    }

    @Nullable
    public UUID getUUIDValue() {
        return UUID.fromString(this.getStringValue());
    }

    @Nullable
    public OffsetDateTime getOffsetDateTimeValue() {
        return OffsetDateTime.parse(this.getStringValue());
    }

    @Nullable
    public LocalDate getLocalDateValue() {
        return LocalDate.parse(this.getStringValue());
    }

    @Nullable
    public LocalTime getLocalTimeValue() {
        return LocalTime.parse(this.getStringValue());
    }

    @Nullable
    public PeriodAndDuration getPeriodAndDurationValue() {
        return PeriodAndDuration.parse((String)this.getStringValue());
    }

    @Nullable
    public <T> List<T> getCollectionOfPrimitiveValues(@Nonnull Class<T> targetClass) {
        throw new UnsupportedOperationException(NO_STRUCTURED_DATA_MESSAGE);
    }

    @Nullable
    public <T extends Parsable> List<T> getCollectionOfObjectValues(@Nonnull ParsableFactory<T> factory) {
        throw new UnsupportedOperationException(NO_STRUCTURED_DATA_MESSAGE);
    }

    @Nullable
    public <T extends Enum<T>> List<T> getCollectionOfEnumValues(@Nonnull ValuedEnumParser<T> enumParser) {
        throw new UnsupportedOperationException(NO_STRUCTURED_DATA_MESSAGE);
    }

    @Nonnull
    public <T extends Parsable> T getObjectValue(@Nonnull ParsableFactory<T> factory) {
        throw new UnsupportedOperationException(NO_STRUCTURED_DATA_MESSAGE);
    }

    @Nullable
    public <T extends Enum<T>> T getEnumValue(@Nonnull ValuedEnumParser<T> enumParser) {
        String rawValue = this.getStringValue();
        if (rawValue == null || rawValue.isEmpty()) {
            return null;
        }
        return (T)enumParser.forValue(rawValue);
    }

    @Nullable
    public <T extends Enum<T>> EnumSet<T> getEnumSetValue(@Nonnull ValuedEnumParser<T> enumParser) {
        throw new UnsupportedOperationException(NO_STRUCTURED_DATA_MESSAGE);
    }

    @Nullable
    public Consumer<Parsable> getOnBeforeAssignFieldValues() {
        return this.onBeforeAssignFieldValues;
    }

    @Nullable
    public Consumer<Parsable> getOnAfterAssignFieldValues() {
        return this.onAfterAssignFieldValues;
    }

    public void setOnBeforeAssignFieldValues(@Nullable Consumer<Parsable> value) {
        this.onBeforeAssignFieldValues = value;
    }

    public void setOnAfterAssignFieldValues(@Nullable Consumer<Parsable> value) {
        this.onAfterAssignFieldValues = value;
    }

    @Nullable
    public byte[] getByteArrayValue() {
        String base64 = this.getStringValue();
        if (base64 == null || base64.isEmpty()) {
            return null;
        }
        return Base64.getDecoder().decode(base64);
    }
}

