/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.serialization;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import com.microsoft.kiota.serialization.DefaultGsonBuilder;
import com.microsoft.kiota.serialization.JsonParseNode;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.ParseNodeFactory;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class JsonParseNodeFactory
implements ParseNodeFactory {
    private final Gson gson;
    private static final String validContentType = "application/json";

    public JsonParseNodeFactory() {
        this(DefaultGsonBuilder.getDefaultInstance());
    }

    public JsonParseNodeFactory(@Nonnull Gson gson) {
        Objects.requireNonNull(gson, "parameter gson cannot be null");
        this.gson = gson;
    }

    @Nonnull
    public String getValidContentType() {
        return validContentType;
    }

    @Nonnull
    public ParseNode getParseNode(@Nonnull String contentType, @Nonnull InputStream rawResponse) {
        JsonParseNode jsonParseNode;
        Objects.requireNonNull(contentType, "parameter contentType cannot be null");
        Objects.requireNonNull(rawResponse, "parameter rawResponse cannot be null");
        if (contentType.isEmpty()) {
            throw new NullPointerException("contentType cannot be empty");
        }
        if (!contentType.equals(validContentType)) {
            throw new IllegalArgumentException("expected a application/json content type");
        }
        InputStreamReader reader = new InputStreamReader(rawResponse, StandardCharsets.UTF_8);
        try {
            jsonParseNode = new JsonParseNode(JsonParser.parseReader((Reader)reader), this.gson);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException("could not close the reader", ex);
            }
        }
        reader.close();
        return jsonParseNode;
    }
}

