/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.util.ported;

import com.microsoft.identity.common.java.logging.Logger;
import edu.umd.cs.findbugs.annotations.Nullable;
import lombok.NonNull;

public final class ObjectUtils {
    private static String TAG = ObjectUtils.class.getSimpleName();

    private ObjectUtils() {
    }

    public static boolean equals(@Nullable Object o1, @Nullable Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    public static void throwIfArgumentIsNull(@Nullable Object argument, @NonNull String argumentName, @NonNull String methodName) throws NullPointerException {
        if (argumentName == null) {
            throw new NullPointerException("argumentName is marked non-null but is null");
        }
        if (methodName == null) {
            throw new NullPointerException("methodName is marked non-null but is null");
        }
        if (argument == null) {
            Logger.error(TAG + methodName, argumentName + " is null.", null);
            throw new NullPointerException(argumentName + " is null.");
        }
    }
}

