/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.util.StringUtil;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class QueryParamsAdapter
extends TypeAdapter<List<Map.Entry<String, String>>> {
    private static final String TAG = QueryParamsAdapter.class.getSimpleName();
    private static final Gson mGson;
    boolean mWriteProperFormat = false;

    public void write(JsonWriter out, List<Map.Entry<String, String>> queryParams) throws IOException {
        if (this.mWriteProperFormat) {
            this.writeProperFormat(out, queryParams);
        } else {
            this.writeListPairFormat(out, queryParams);
        }
    }

    private void writeProperFormat(JsonWriter out, List<Map.Entry<String, String>> queryParams) throws IOException {
        out.beginObject();
        for (Map.Entry<String, String> keyValuePair : queryParams) {
            out.name(keyValuePair.getKey());
            out.value(keyValuePair.getValue());
        }
        out.endObject();
    }

    private void writeListPairFormat(JsonWriter out, List<Map.Entry<String, String>> queryParams) throws IOException {
        out.beginArray();
        for (Map.Entry<String, String> keyValuePair : queryParams) {
            out.beginObject();
            out.name("first");
            out.value(keyValuePair.getKey());
            out.name("second");
            out.value(keyValuePair.getValue());
            out.endObject();
        }
        out.endArray();
    }

    public List<Map.Entry<String, String>> read(JsonReader in) throws IOException {
        switch (in.peek()) {
            case BEGIN_ARRAY: {
                return this.readListPairFormat(in);
            }
            case BEGIN_OBJECT: {
                return this.readProperFormat(in);
            }
        }
        return new ArrayList<Map.Entry<String, String>>();
    }

    private List<Map.Entry<String, String>> readProperFormat(JsonReader in) throws IOException {
        ArrayList<Map.Entry<String, String>> result = new ArrayList<Map.Entry<String, String>>();
        in.beginObject();
        while (in.hasNext()) {
            AbstractMap.SimpleEntry<String, String> keyValuePair = new AbstractMap.SimpleEntry<String, String>(in.nextName(), in.nextString());
            result.add(keyValuePair);
        }
        in.endObject();
        return result;
    }

    private List<Map.Entry<String, String>> readListPairFormat(JsonReader in) throws IOException {
        ArrayList<Map.Entry<String, String>> result = new ArrayList<Map.Entry<String, String>>();
        in.beginArray();
        while (in.hasNext()) {
            in.beginObject();
            String key = "";
            String value = "";
            while (in.hasNext()) {
                String name = in.nextName();
                if (StringUtil.equalsIgnoreCase(name, "first")) {
                    key = in.nextString();
                    continue;
                }
                if (StringUtil.equalsIgnoreCase(name, "second")) {
                    value = in.nextString();
                    continue;
                }
                throw new JsonSyntaxException("Unexpected NAME field: " + name);
            }
            result.add(new AbstractMap.SimpleEntry<String, String>(key, value));
            in.endObject();
        }
        in.endArray();
        return result;
    }

    public static String _toJson(List<Map.Entry<String, String>> extraQueryStringParameters) {
        return mGson.toJson(extraQueryStringParameters, QueryParamsAdapter.getListType());
    }

    public static List<Map.Entry<String, String>> _fromJson(String jsonString) throws ClientException {
        String methodName = ":_fromJson";
        if (StringUtil.isNullOrEmpty(jsonString)) {
            return new ArrayList<Map.Entry<String, String>>();
        }
        try {
            return (List)mGson.fromJson(jsonString, QueryParamsAdapter.getListType());
        }
        catch (JsonSyntaxException e) {
            String errorMessage = "malformed json string:" + jsonString;
            Logger.error(TAG + ":_fromJson", errorMessage, e);
            throw new ClientException("json_parse_failure", errorMessage, e);
        }
    }

    public static Type getListType() {
        return TypeToken.getParameterized(List.class, (Type[])new Type[]{TypeToken.getParameterized(Map.Entry.class, (Type[])new Type[]{String.class, String.class}).getRawType()}).getType();
    }

    public QueryParamsAdapter(boolean mWriteProperFormat) {
        this.mWriteProperFormat = mWriteProperFormat;
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(QueryParamsAdapter.getListType(), (Object)new QueryParamsAdapter(false));
        mGson = gsonBuilder.create();
    }
}

