/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.util;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.AuthenticationConstants;
import com.microsoft.identity.common.java.crypto.BasicSigner;
import com.microsoft.identity.common.java.crypto.ISigner;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.util.StringUtil;
import cz.msebera.android.httpclient.extras.Base64;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class JWSBuilder {
    private static final long SECONDS_MS = 1000L;
    private static final String JWS_HEADER_ALG = "RS256";
    private static final String SIGNING_ALGORITHM = "SHA256withRSA";
    private static final String TAG = "JWSBuilder";
    private static final ISigner sSigner = new BasicSigner();

    public String generateSignedJWT(String nonce, String audience, PrivateKey privateKey, PublicKey pubKey, X509Certificate cert) throws ClientException {
        String signature;
        String signingInput;
        String methodName = ":generateSignedJWT";
        if (StringUtil.isNullOrEmpty(nonce)) {
            throw new IllegalArgumentException("nonce");
        }
        if (StringUtil.isNullOrEmpty(audience)) {
            throw new IllegalArgumentException("audience");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("privateKey");
        }
        if (pubKey == null) {
            throw new IllegalArgumentException("pubKey");
        }
        Gson gson = new Gson();
        Claims claims = new Claims();
        claims.mNonce = nonce;
        claims.mAudience = audience;
        claims.mIssueAt = System.currentTimeMillis() / 1000L;
        JwsHeader header = new JwsHeader();
        header.mAlgorithm = JWS_HEADER_ALG;
        header.mType = "JWT";
        try {
            JwsHeader.access$702(header, new String[1]);
            ((JwsHeader)header).mCert[0] = Base64.encodeToString((byte[])cert.getEncoded(), (int)2);
            String headerJsonString = gson.toJson((Object)header);
            String claimsJsonString = gson.toJson((Object)claims);
            Logger.verbose("JWSBuilder:generateSignedJWT", "Generate client certificate challenge response JWS Header. ");
            signingInput = StringUtil.encodeUrlSafeString(headerJsonString) + "." + StringUtil.encodeUrlSafeString(claimsJsonString);
            signature = StringUtil.encodeUrlSafeString(sSigner.sign(privateKey, SIGNING_ALGORITHM, signingInput.getBytes(AuthenticationConstants.ENCODING_UTF8)));
        }
        catch (CertificateEncodingException e) {
            throw new ClientException("Certificate encoding is not generated", "Certificate encoding error", e);
        }
        return signingInput + "." + signature;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    static final class JwsHeader {
        @SerializedName(value="alg")
        private String mAlgorithm;
        @SerializedName(value="typ")
        private String mType;
        @SerializedName(value="x5c")
        private String[] mCert;

        private JwsHeader() {
        }

        static /* synthetic */ String[] access$702(JwsHeader x0, String[] x1) {
            x0.mCert = x1;
            return x1;
        }
    }

    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    static final class Claims {
        @SerializedName(value="aud")
        private String mAudience;
        @SerializedName(value="iat")
        private long mIssueAt;
        @SerializedName(value="nonce")
        private String mNonce;

        private Claims() {
        }
    }
}

