/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.telemetry.events;

import com.microsoft.identity.common.java.controllers.ExceptionAdapter;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.UserCancelException;
import com.microsoft.identity.common.java.result.AcquireTokenResult;
import com.microsoft.identity.common.java.telemetry.events.BaseEvent;
import javax.annotation.Nullable;
import lombok.NonNull;

public class ApiEndEvent
extends BaseEvent {
    public ApiEndEvent() {
        this.names("api_end_event");
        this.types("Microsoft.MSAL.api_event");
    }

    public ApiEndEvent(@NonNull String apiId) {
        if (apiId == null) {
            throw new NullPointerException("apiId is marked non-null but is null");
        }
        this.names("api_end_event");
        this.types("Microsoft.MSAL.api_event");
        this.putApiId(apiId);
    }

    public ApiEndEvent putResult(@Nullable AcquireTokenResult result) {
        if (result == null) {
            return this;
        }
        this.put("_is_successful", result.getSucceeded() != false ? "true" : "false");
        if (null != result.getLocalAuthenticationResult()) {
            this.put("Microsoft.MSAL.user_id", result.getLocalAuthenticationResult().getUniqueId());
            this.put("Microsoft.MSAL.tenant_id", result.getLocalAuthenticationResult().getTenantId());
            this.put("Microsoft.MSAL.spe_ring", result.getLocalAuthenticationResult().getSpeRing());
            this.put("Microsoft.MSAL.rt_age", result.getLocalAuthenticationResult().getRefreshTokenAge());
            this.correlationId(result.getLocalAuthenticationResult().getCorrelationId());
        }
        return this;
    }

    public ApiEndEvent putException(@Nullable Exception exception) {
        if (exception == null) {
            return this;
        }
        BaseException adaptedException = ExceptionAdapter.baseExceptionFromException(exception);
        if (adaptedException instanceof UserCancelException) {
            this.put("Microsoft.MSAL.user_cancel", "true");
        }
        this.put("Microsoft.MSAL.server_error_code", adaptedException.getCliTelemErrorCode());
        this.put("Microsoft.MSAL.server_sub_error_code", adaptedException.getCliTelemSubErrorCode());
        this.put("Microsoft.MSAL.error_code", adaptedException.getErrorCode());
        this.put("Microsoft.MSAL.spe_ring", adaptedException.getSpeRing());
        this.put("Microsoft.MSAL.error_description", adaptedException.getMessage());
        this.put("Microsoft.MSAL.rt_age", adaptedException.getRefreshTokenAge());
        this.put("_is_successful", "false");
        return this;
    }

    @NonNull
    public ApiEndEvent putApiId(@NonNull String apiId) {
        if (apiId == null) {
            throw new NullPointerException("apiId is marked non-null but is null");
        }
        this.put("Microsoft.MSAL.api_id", apiId);
        return this;
    }

    @Override
    public ApiEndEvent put(@NonNull String propertyName, String propertyValue) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        super.put(propertyName, propertyValue);
        return this;
    }

    public ApiEndEvent isApiCallSuccessful(Boolean isSuccessful) {
        this.put("_is_successful", isSuccessful != false ? "true" : "false");
        return this;
    }

    public ApiEndEvent putApiErrorCode(@NonNull String errorCode) {
        if (errorCode == null) {
            throw new NullPointerException("errorCode is marked non-null but is null");
        }
        this.put("Microsoft.MSAL.error_code", errorCode);
        return this;
    }
}

