/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.storage;

import com.microsoft.identity.common.java.cache.IMultiTypeNameValueStorage;
import com.microsoft.identity.common.java.interfaces.AbstractPerSeparatorMultiTypeNameValueStorage;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;

public class StringSeparatedMultiTypeNameValueStorage
extends AbstractPerSeparatorMultiTypeNameValueStorage<String> {
    @NonNull
    private final IPlatformComponents mPlatformComponents;
    private final boolean mShouldEncrypt;
    private static final int MAX_ITEM_COUNT = 25;
    private static final Map<String, IMultiTypeNameValueStorage> sStringSeparatedStorageCache = Collections.synchronizedMap(new LinkedHashMap<String, IMultiTypeNameValueStorage>(2, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, IMultiTypeNameValueStorage> eldest) {
            return this.size() > 25;
        }
    });

    @Override
    @NonNull
    protected synchronized IMultiTypeNameValueStorage getStoreForSeparator(@NonNull String separator) {
        if (separator == null) {
            throw new NullPointerException("separator is marked non-null but is null");
        }
        return sStringSeparatedStorageCache.computeIfAbsent(separator, key -> {
            if (this.mShouldEncrypt) {
                return this.mPlatformComponents.getEncryptedFileStore(separator, this.mPlatformComponents.getStorageEncryptionManager());
            }
            return this.mPlatformComponents.getFileStore(separator);
        });
    }

    public StringSeparatedMultiTypeNameValueStorage(@NonNull IPlatformComponents mPlatformComponents, boolean mShouldEncrypt) {
        if (mPlatformComponents == null) {
            throw new NullPointerException("mPlatformComponents is marked non-null but is null");
        }
        this.mPlatformComponents = mPlatformComponents;
        this.mShouldEncrypt = mShouldEncrypt;
    }
}

