/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.storage;

import com.microsoft.identity.common.java.crypto.IKeyAccessor;
import com.microsoft.identity.common.java.crypto.KeyAccessorStringAdapter;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.interfaces.INameValueStorage;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.storage.IGenericTypeStringAdapter;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.ported.Predicate;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;

public class EncryptedNameValueStorage<T>
implements INameValueStorage<T> {
    private static final String TAG = EncryptedNameValueStorage.class.getSimpleName();
    @NonNull
    private final INameValueStorage<String> mRawNameValueStorage;
    @NonNull
    private final KeyAccessorStringAdapter mEncryptionManager;
    @NonNull
    private final IGenericTypeStringAdapter<T> mStringAdapter;

    public EncryptedNameValueStorage(@NonNull INameValueStorage<String> rawNameValueStringStorage, @NonNull IKeyAccessor encryptionManager, @NonNull IGenericTypeStringAdapter<T> stringAdapter) {
        if (rawNameValueStringStorage == null) {
            throw new NullPointerException("rawNameValueStringStorage is marked non-null but is null");
        }
        if (encryptionManager == null) {
            throw new NullPointerException("encryptionManager is marked non-null but is null");
        }
        if (stringAdapter == null) {
            throw new NullPointerException("stringAdapter is marked non-null but is null");
        }
        this.mRawNameValueStorage = rawNameValueStringStorage;
        this.mEncryptionManager = new KeyAccessorStringAdapter(encryptionManager);
        this.mStringAdapter = stringAdapter;
    }

    @Override
    @Nullable
    public T get(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        String encryptedString = this.mRawNameValueStorage.get(name);
        if (StringUtil.isNullOrEmpty(encryptedString)) {
            return null;
        }
        String decryptedString = this.decrypt(encryptedString);
        if (StringUtil.isNullOrEmpty(decryptedString)) {
            this.logWarningAndRemoveKey(name);
            return null;
        }
        return this.mStringAdapter.adapt(decryptedString);
    }

    @Override
    @NonNull
    public Map<String, T> getAll() {
        Map<String, String> stringEntries = this.mRawNameValueStorage.getAll();
        HashMap<String, T> decryptedEntries = new HashMap<String, T>();
        for (Map.Entry<String, String> entry : stringEntries.entrySet()) {
            T decryptedValue = this.get(entry.getKey());
            if (decryptedValue == null) continue;
            decryptedEntries.put(entry.getKey(), decryptedValue);
        }
        return decryptedEntries;
    }

    @Override
    public void put(@NonNull String name, @Nullable T value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            this.mRawNameValueStorage.put(name, null);
            return;
        }
        String adaptedValue = this.mStringAdapter.adapt(value);
        if (StringUtil.isNullOrEmpty(adaptedValue)) {
            this.mRawNameValueStorage.put(name, adaptedValue);
            return;
        }
        String encryptedValue = this.encrypt(adaptedValue);
        this.mRawNameValueStorage.put(name, encryptedValue);
    }

    @Override
    public void remove(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.mRawNameValueStorage.remove(name);
    }

    @Override
    public void clear() {
        this.mRawNameValueStorage.clear();
    }

    @Override
    @NonNull
    public Set<String> keySet() {
        return this.mRawNameValueStorage.keySet();
    }

    @Override
    public Iterator<Map.Entry<String, T>> getAllFilteredByKey(@NonNull Predicate<String> keyFilter) {
        if (keyFilter == null) {
            throw new NullPointerException("keyFilter is marked non-null but is null");
        }
        HashMap<String, T> newMap = new HashMap<String, T>();
        for (Map.Entry<String, T> entry : this.getAll().entrySet()) {
            if (!keyFilter.test(entry.getKey())) continue;
            newMap.put(entry.getKey(), entry.getValue());
        }
        return newMap.entrySet().iterator();
    }

    @Nullable
    private String encrypt(@NonNull String clearText) {
        if (clearText == null) {
            throw new NullPointerException("clearText is marked non-null but is null");
        }
        return this.encryptDecryptInternal(clearText, true);
    }

    @Nullable
    private String decrypt(@NonNull String encryptedBlob) {
        if (encryptedBlob == null) {
            throw new NullPointerException("encryptedBlob is marked non-null but is null");
        }
        return this.encryptDecryptInternal(encryptedBlob, false);
    }

    @Nullable
    private String encryptDecryptInternal(@NonNull String inputText, boolean encrypt) {
        if (inputText == null) {
            throw new NullPointerException("inputText is marked non-null but is null");
        }
        String methodName = "encryptDecryptInternal";
        try {
            return encrypt ? this.mEncryptionManager.encrypt(inputText) : this.mEncryptionManager.decrypt(inputText);
        }
        catch (ClientException e) {
            Logger.error(TAG + ":" + "encryptDecryptInternal", "Failed to " + (encrypt ? "encrypt" : "decrypt") + " value", encrypt ? null : e);
            return null;
        }
    }

    private void logWarningAndRemoveKey(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        Logger.warn(TAG, "Failed to decrypt value! This usually signals an issue with KeyStore or the provided SecretKeys.");
        this.remove(key);
    }
}

