/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.microsoft.microsoftsts;

import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationErrorResponse;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationResponse;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationResult;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResultFactory;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationStatus;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.UrlUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.URI;
import java.util.Map;
import lombok.NonNull;

public class MicrosoftStsAuthorizationResultFactory
extends AuthorizationResultFactory<MicrosoftStsAuthorizationResult, MicrosoftStsAuthorizationRequest> {
    private static final String TAG = MicrosoftStsAuthorizationResultFactory.class.getSimpleName();

    @Override
    protected MicrosoftStsAuthorizationResult createAuthorizationResultWithErrorResponse(AuthorizationStatus authStatus, @NonNull String error, @Nullable String errorDescription) {
        if (error == null) {
            throw new NullPointerException("error is marked non-null but is null");
        }
        Logger.info(TAG, "Error is returned from webview redirect");
        Logger.infoPII(TAG, "error: " + error + " errorDescription: " + errorDescription);
        MicrosoftStsAuthorizationErrorResponse errorResponse = new MicrosoftStsAuthorizationErrorResponse(error, errorDescription);
        return new MicrosoftStsAuthorizationResult(authStatus, errorResponse);
    }

    @Override
    protected MicrosoftStsAuthorizationResult parseRedirectUriAndCreateAuthorizationResult(@NonNull URI redirectUri, @Nullable String requestStateParameter) {
        AuthorizationResult result;
        if (redirectUri == null) {
            throw new NullPointerException("redirectUri is marked non-null but is null");
        }
        String methodName = "parseUrlAndCreateAuthorizationResponse";
        Map<String, String> urlParameters = UrlUtil.getParameters(redirectUri);
        if (urlParameters.isEmpty()) {
            Logger.warn(TAG, "Invalid server response, empty query string from the webview redirect.");
            result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "authorization_failed", "The authorization server returned an invalid response.");
        } else {
            result = urlParameters.containsKey("code") ? this.validateAndCreateAuthorizationResult((Map)urlParameters, requestStateParameter, (String)null) : (urlParameters.containsKey("error") ? this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, urlParameters.get("error"), urlParameters.get("error_subcode"), urlParameters.get("error_description")) : this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "authorization_failed", "The authorization server returned an invalid response."));
        }
        return result;
    }

    private MicrosoftStsAuthorizationResult createAuthorizationResultWithErrorResponse(AuthorizationStatus authStatus, String error, String errorSubcode, String errorDescription) {
        Logger.info(TAG, "Error is returned from webview redirect");
        Logger.infoPII(TAG, "error: " + error + "error subcode:" + errorSubcode + " errorDescription: " + errorDescription);
        MicrosoftStsAuthorizationErrorResponse errorResponse = new MicrosoftStsAuthorizationErrorResponse(error, errorSubcode, errorDescription);
        return new MicrosoftStsAuthorizationResult(authStatus, errorResponse);
    }

    @Override
    protected MicrosoftStsAuthorizationResult validateAndCreateAuthorizationResult(@NonNull Map<String, String> urlParameters, @Nullable String requestStateParameter, @Nullable String correlationId) {
        MicrosoftStsAuthorizationResult result;
        if (urlParameters == null) {
            throw new NullPointerException("urlParameters is marked non-null but is null");
        }
        String state = urlParameters.get("state");
        String code = urlParameters.get("code");
        if (StringUtil.isNullOrEmpty(state)) {
            Logger.warn(TAG, "State parameter is not returned from the webview redirect.");
            result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "state_mismatch", "State is not returned");
        } else if (StringUtil.isNullOrEmpty(requestStateParameter) || !requestStateParameter.equals(state)) {
            Logger.warn(TAG, "State parameter returned from the redirect is not same as the one sent in request.");
            result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "state_mismatch", "Returned state from authorize endpoint is not the same as the one sent");
        } else {
            Logger.info(TAG, "Auth code is successfully returned from webview redirect.");
            MicrosoftStsAuthorizationResponse authResponse = new MicrosoftStsAuthorizationResponse(code, state, urlParameters);
            result = new MicrosoftStsAuthorizationResult(AuthorizationStatus.SUCCESS, authResponse);
        }
        return result;
    }
}

