/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory;

import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.util.JsonUtil;
import com.microsoft.identity.common.java.util.StringUtil;
import cz.msebera.android.httpclient.extras.Base64;
import java.io.Serializable;
import java.util.Map;
import lombok.NonNull;
import org.json.JSONException;

public class ClientInfo
implements Serializable {
    private static final String UNIQUE_IDENTIFIER = "uid";
    private static final String UNIQUE_TENANT_IDENTIFIER = "utid";
    private static final long serialVersionUID = 3326461566190095403L;
    private String mUid;
    private String mUtid;
    private String mRawClientInfo;

    public ClientInfo(@NonNull String rawClientInfo) throws ServiceException {
        Map<String, String> clientInfoItems;
        if (rawClientInfo == null) {
            throw new NullPointerException("rawClientInfo is marked non-null but is null");
        }
        if (StringUtil.isNullOrEmpty(rawClientInfo)) {
            throw new IllegalArgumentException("ClientInfo cannot be null or blank.");
        }
        String decodedClientInfo = StringUtil.fromByteArray(Base64.decode((String)rawClientInfo, (int)8));
        try {
            clientInfoItems = JsonUtil.extractJsonObjectIntoMap(decodedClientInfo);
        }
        catch (JSONException e) {
            throw new ServiceException("", "invalid_jwt", e);
        }
        this.mUid = clientInfoItems.get(UNIQUE_IDENTIFIER);
        this.mUtid = clientInfoItems.get(UNIQUE_TENANT_IDENTIFIER);
        this.mRawClientInfo = rawClientInfo;
    }

    public String getUid() {
        return this.mUid;
    }

    public String getUtid() {
        return this.mUtid;
    }

    public String getRawClientInfo() {
        return this.mRawClientInfo;
    }
}

