/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.platform;

import com.microsoft.identity.common.java.util.StringUtil;
import cz.msebera.android.httpclient.extras.Base64;
import org.json.JSONException;
import org.json.JSONObject;

public class JweResponse {
    JweHeader mJweHeader;
    String mEncryptedKey;
    String mIv;
    String mPayload;
    String mAuthenticationTag;

    public JweHeader getJweHeader() {
        return this.mJweHeader;
    }

    public String getEncryptedKey() {
        return this.mEncryptedKey;
    }

    public String getIV() {
        return this.mIv;
    }

    public String getPayload() {
        return this.mPayload;
    }

    public String getAuthenticationTag() {
        return this.mAuthenticationTag;
    }

    public static JweResponse parseJwe(String jwe) throws JSONException {
        JweResponse response = new JweResponse();
        String[] split = jwe.split("\\.");
        if (split.length < 4) {
            throw new IllegalArgumentException("Invalid JWE");
        }
        String header = split[0];
        response.mEncryptedKey = split[1];
        response.mIv = split[2];
        response.mPayload = split[3];
        if (split.length > 4) {
            response.mAuthenticationTag = split[4];
        }
        byte[] headerDecodedBytes = Base64.decode((String)header, (int)8);
        String decodedHeader = StringUtil.fromByteArray(headerDecodedBytes);
        JSONObject jsonObject = new JSONObject(decodedHeader);
        response.mJweHeader = JweHeader.builder().algorithm(jsonObject.optString("alg")).type(jsonObject.optString("typ")).x509CertificateThumbprint(jsonObject.optString("x5t")).x509Certificate(jsonObject.optString("x5c")).keyID(jsonObject.optString("kid")).keyUse(jsonObject.optString("use")).encryptionAlgorithm(jsonObject.optString("enc")).context(jsonObject.optString("ctx")).build();
        return response;
    }

    public static class JweHeader {
        private final String mAlgorithm;
        private final String mType;
        private final String mX509CertificateThumbprint;
        private final String mX509Certificate;
        private final String mKeyID;
        private final String mKeyUse;
        private final String mEncryptionAlgorithm;
        private final String mContext;

        JweHeader(String algorithm, String type, String x509CertificateThumbprint, String x509Certificate, String keyID, String keyUse, String encryptionAlgorithm, String context) {
            this.mAlgorithm = algorithm;
            this.mType = type;
            this.mX509CertificateThumbprint = x509CertificateThumbprint;
            this.mX509Certificate = x509Certificate;
            this.mKeyID = keyID;
            this.mKeyUse = keyUse;
            this.mEncryptionAlgorithm = encryptionAlgorithm;
            this.mContext = context;
        }

        public static JweHeaderBuilder builder() {
            return new JweHeaderBuilder();
        }

        public String getAlgorithm() {
            return this.mAlgorithm;
        }

        public String getType() {
            return this.mType;
        }

        public String getX509CertificateThumbprint() {
            return this.mX509CertificateThumbprint;
        }

        public String getX509Certificate() {
            return this.mX509Certificate;
        }

        public String getKeyID() {
            return this.mKeyID;
        }

        public String getKeyUse() {
            return this.mKeyUse;
        }

        public String getEncryptionAlgorithm() {
            return this.mEncryptionAlgorithm;
        }

        public String getContext() {
            return this.mContext;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JweHeader)) {
                return false;
            }
            JweHeader other = (JweHeader)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$mAlgorithm = this.getAlgorithm();
            String other$mAlgorithm = other.getAlgorithm();
            if (this$mAlgorithm == null ? other$mAlgorithm != null : !this$mAlgorithm.equals(other$mAlgorithm)) {
                return false;
            }
            String this$mType = this.getType();
            String other$mType = other.getType();
            if (this$mType == null ? other$mType != null : !this$mType.equals(other$mType)) {
                return false;
            }
            String this$mX509CertificateThumbprint = this.getX509CertificateThumbprint();
            String other$mX509CertificateThumbprint = other.getX509CertificateThumbprint();
            if (this$mX509CertificateThumbprint == null ? other$mX509CertificateThumbprint != null : !this$mX509CertificateThumbprint.equals(other$mX509CertificateThumbprint)) {
                return false;
            }
            String this$mX509Certificate = this.getX509Certificate();
            String other$mX509Certificate = other.getX509Certificate();
            if (this$mX509Certificate == null ? other$mX509Certificate != null : !this$mX509Certificate.equals(other$mX509Certificate)) {
                return false;
            }
            String this$mKeyID = this.getKeyID();
            String other$mKeyID = other.getKeyID();
            if (this$mKeyID == null ? other$mKeyID != null : !this$mKeyID.equals(other$mKeyID)) {
                return false;
            }
            String this$mKeyUse = this.getKeyUse();
            String other$mKeyUse = other.getKeyUse();
            if (this$mKeyUse == null ? other$mKeyUse != null : !this$mKeyUse.equals(other$mKeyUse)) {
                return false;
            }
            String this$mEncryptionAlgorithm = this.getEncryptionAlgorithm();
            String other$mEncryptionAlgorithm = other.getEncryptionAlgorithm();
            if (this$mEncryptionAlgorithm == null ? other$mEncryptionAlgorithm != null : !this$mEncryptionAlgorithm.equals(other$mEncryptionAlgorithm)) {
                return false;
            }
            String this$mContext = this.getContext();
            String other$mContext = other.getContext();
            return !(this$mContext == null ? other$mContext != null : !this$mContext.equals(other$mContext));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JweHeader;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $mAlgorithm = this.getAlgorithm();
            result = result * 59 + ($mAlgorithm == null ? 43 : $mAlgorithm.hashCode());
            String $mType = this.getType();
            result = result * 59 + ($mType == null ? 43 : $mType.hashCode());
            String $mX509CertificateThumbprint = this.getX509CertificateThumbprint();
            result = result * 59 + ($mX509CertificateThumbprint == null ? 43 : $mX509CertificateThumbprint.hashCode());
            String $mX509Certificate = this.getX509Certificate();
            result = result * 59 + ($mX509Certificate == null ? 43 : $mX509Certificate.hashCode());
            String $mKeyID = this.getKeyID();
            result = result * 59 + ($mKeyID == null ? 43 : $mKeyID.hashCode());
            String $mKeyUse = this.getKeyUse();
            result = result * 59 + ($mKeyUse == null ? 43 : $mKeyUse.hashCode());
            String $mEncryptionAlgorithm = this.getEncryptionAlgorithm();
            result = result * 59 + ($mEncryptionAlgorithm == null ? 43 : $mEncryptionAlgorithm.hashCode());
            String $mContext = this.getContext();
            result = result * 59 + ($mContext == null ? 43 : $mContext.hashCode());
            return result;
        }

        public static class JweHeaderBuilder {
            private String algorithm;
            private String type;
            private String x509CertificateThumbprint;
            private String x509Certificate;
            private String keyID;
            private String keyUse;
            private String encryptionAlgorithm;
            private String context;

            JweHeaderBuilder() {
            }

            public JweHeaderBuilder algorithm(String algorithm) {
                this.algorithm = algorithm;
                return this;
            }

            public JweHeaderBuilder type(String type) {
                this.type = type;
                return this;
            }

            public JweHeaderBuilder x509CertificateThumbprint(String x509CertificateThumbprint) {
                this.x509CertificateThumbprint = x509CertificateThumbprint;
                return this;
            }

            public JweHeaderBuilder x509Certificate(String x509Certificate) {
                this.x509Certificate = x509Certificate;
                return this;
            }

            public JweHeaderBuilder keyID(String keyID) {
                this.keyID = keyID;
                return this;
            }

            public JweHeaderBuilder keyUse(String keyUse) {
                this.keyUse = keyUse;
                return this;
            }

            public JweHeaderBuilder encryptionAlgorithm(String encryptionAlgorithm) {
                this.encryptionAlgorithm = encryptionAlgorithm;
                return this;
            }

            public JweHeaderBuilder context(String context) {
                this.context = context;
                return this;
            }

            public JweHeader build() {
                return new JweHeader(this.algorithm, this.type, this.x509CertificateThumbprint, this.x509Certificate, this.keyID, this.keyUse, this.encryptionAlgorithm, this.context);
            }

            public String toString() {
                return "JweResponse.JweHeader.JweHeaderBuilder(algorithm=" + this.algorithm + ", type=" + this.type + ", x509CertificateThumbprint=" + this.x509CertificateThumbprint + ", x509Certificate=" + this.x509Certificate + ", keyID=" + this.keyID + ", keyUse=" + this.keyUse + ", encryptionAlgorithm=" + this.encryptionAlgorithm + ", context=" + this.context + ")";
            }
        }
    }
}

