/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.platform;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.microsoft.identity.common.java.AuthenticationConstants;
import com.microsoft.identity.common.java.crypto.IDevicePopManager;
import com.microsoft.identity.common.java.crypto.IKeyStoreKeyManager;
import com.microsoft.identity.common.java.crypto.SecureHardwareState;
import com.microsoft.identity.common.java.crypto.SigningAlgorithm;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.marker.CodeMarkerManager;
import com.microsoft.identity.common.java.platform.AbstractKeyStoreKeyManager;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.TaskCompletedCallbackWithError;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import cz.msebera.android.httpclient.extras.Base64;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import lombok.NonNull;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractDevicePopManager
implements IDevicePopManager {
    private static final String TAG = AbstractDevicePopManager.class.getSimpleName();
    private static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String DEFAULT_KEYSTORE_ENTRY_ALIAS = "microsoft-device-pop";
    private static final int RSA_KEY_SIZE = 2048;
    private static final String PRIVATE_KEY_NOT_FOUND = "Not an instance of a PrivateKeyEntry";
    public static final Type MAP_STRING_STRING_TYPE = TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, String.class}).getType();
    public static final Gson GSON = new Gson();
    public static final String STRONG_BOX_UNAVAILABLE_EXCEPTION = "StrongBoxUnavailableException";
    protected final IKeyStoreKeyManager<KeyStore.PrivateKeyEntry> mKeyManager;
    private static final String ANDROID_KEYSTORE = "AndroidKeyStore";
    private static final ExecutorService sThreadExecutor = Executors.newFixedThreadPool(5);
    private static final CodeMarkerManager sCodeMarkerManager = CodeMarkerManager.getInstance();

    @Override
    public IKeyStoreKeyManager<KeyStore.PrivateKeyEntry> getKeyManager() {
        return this.mKeyManager;
    }

    public AbstractDevicePopManager(@NonNull IKeyStoreKeyManager<KeyStore.PrivateKeyEntry> keyManager) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        if (keyManager == null) {
            throw new NullPointerException("keyManager is marked non-null but is null");
        }
        this.mKeyManager = keyManager;
    }

    @Override
    public boolean asymmetricKeyExists() {
        return this.mKeyManager.exists();
    }

    @Override
    public boolean asymmetricKeyExists(@NonNull String thumbprint) {
        if (thumbprint == null) {
            throw new NullPointerException("thumbprint is marked non-null but is null");
        }
        return this.mKeyManager.hasThumbprint(thumbprint.getBytes(UTF8));
    }

    @Override
    public String getAsymmetricKeyThumbprint() throws ClientException {
        return new String(this.mKeyManager.getThumbprint(), UTF8);
    }

    @Override
    public void generateAsymmetricKey(final @NonNull TaskCompletedCallbackWithError<String, ClientException> callback) {
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        sThreadExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.onTaskCompleted(AbstractDevicePopManager.this.generateAsymmetricKey());
                }
                catch (ClientException e) {
                    callback.onError(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateAsymmetricKey() throws ClientException {
        String errCode;
        Throwable exception;
        String methodTag = TAG + ":generateAsymmetricKey";
        try {
            sCodeMarkerManager.markCode("30001");
            KeyPair keyPair = this.generateNewRsaKeyPair(2048);
            RSAKey rsaKey = AbstractKeyStoreKeyManager.getRsaKeyForKeyPair(keyPair);
            String string = AbstractKeyStoreKeyManager.getThumbprintForRsaKey(rsaKey);
            return string;
        }
        catch (UnsupportedOperationException e) {
            exception = e;
            errCode = "keystore_produced_invalid_cert";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (NoSuchProviderException e) {
            exception = e;
            errCode = "android_keystore_unavailable";
        }
        catch (InvalidAlgorithmParameterException e) {
            exception = e;
            errCode = "keystore_initialization_failed";
        }
        catch (JOSEException e) {
            exception = e;
            errCode = "failed_to_compute_thumbprint_with_sha256";
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        finally {
            sCodeMarkerManager.markCode("30002");
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(methodTag, clientException.getMessage(), clientException);
        throw clientException;
    }

    public abstract KeyPair generateNewRsaKeyPair(int var1) throws UnsupportedOperationException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, ClientException, KeyStoreException;

    @Override
    @Nullable
    public Date getAsymmetricKeyCreationDate() throws ClientException {
        return this.mKeyManager.getCreationDate();
    }

    @Override
    public boolean clearAsymmetricKey() {
        return this.mKeyManager.clear();
    }

    @Override
    public String getRequestConfirmation() throws ClientException {
        String methodTag = TAG + ":getRequestConfirmation";
        final CountDownLatch latch = new CountDownLatch(1);
        final String[] result = new String[1];
        final ClientException[] errorResult = new ClientException[1];
        this.getRequestConfirmation(new TaskCompletedCallbackWithError<String, ClientException>(){

            @Override
            public void onTaskCompleted(@NonNull String reqCnf) {
                if (reqCnf == null) {
                    throw new NullPointerException("reqCnf is marked non-null but is null");
                }
                result[0] = reqCnf;
                latch.countDown();
            }

            @Override
            public void onError(@NonNull ClientException error) {
                if (error == null) {
                    throw new NullPointerException("error is marked non-null but is null");
                }
                errorResult[0] = error;
                latch.countDown();
            }
        });
        try {
            latch.await();
            if (null != result[0]) {
                return result[0];
            }
            throw errorResult[0];
        }
        catch (InterruptedException e) {
            Logger.error(methodTag, "Interrupted while waiting on callback.", e);
            throw new ClientException("operation_interrupted", e.getMessage(), e);
        }
    }

    @Override
    public void getRequestConfirmation(final @NonNull TaskCompletedCallbackWithError<String, ClientException> callback) {
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        final String methodTag = TAG + ":getRequestConfirmation";
        sThreadExecutor.submit(new Runnable(){

            @Override
            public void run() {
                String errCode;
                Throwable exception;
                try {
                    KeyStore.PrivateKeyEntry keyEntry = AbstractDevicePopManager.this.mKeyManager.getEntry();
                    KeyPair rsaKeyPair = AbstractKeyStoreKeyManager.getKeyPairForEntry(keyEntry);
                    RSAKey rsaKey = AbstractKeyStoreKeyManager.getRsaKeyForKeyPair(rsaKeyPair);
                    String base64UrlEncodedJwkJsonStr = AbstractDevicePopManager.getReqCnfForRsaKey(rsaKey);
                    callback.onTaskCompleted(base64UrlEncodedJwkJsonStr);
                    return;
                }
                catch (KeyStoreException e) {
                    exception = e;
                    errCode = "keystore_not_initialized";
                }
                catch (NoSuchAlgorithmException e) {
                    exception = e;
                    errCode = "no_such_algorithm";
                }
                catch (UnrecoverableEntryException e) {
                    exception = e;
                    errCode = "protection_params_invalid";
                }
                catch (JOSEException e) {
                    exception = e;
                    errCode = "failed_to_compute_thumbprint_with_sha256";
                }
                catch (JSONException e) {
                    exception = e;
                    errCode = "json_construction_failed";
                }
                ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
                Logger.error(methodTag, clientException.getMessage(), clientException);
                callback.onError(clientException);
            }
        });
    }

    @Override
    @NonNull
    public String sign(@NonNull SigningAlgorithm alg, @NonNull String input) throws ClientException {
        if (alg == null) {
            throw new NullPointerException("alg is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return Base64.encodeToString((byte[])this.sign(alg, input.getBytes(UTF8)), (int)2);
    }

    @Override
    public byte[] sign(@NonNull SigningAlgorithm alg, @NonNull byte[] inputBytesToSign) throws ClientException {
        String errCode;
        GeneralSecurityException exception;
        if (alg == null) {
            throw new NullPointerException("alg is marked non-null but is null");
        }
        if (inputBytesToSign == null) {
            throw new NullPointerException("inputBytesToSign is marked non-null but is null");
        }
        String methodTag = TAG + ":sign";
        try {
            KeyStore.PrivateKeyEntry keyEntry = this.mKeyManager.getEntry();
            if (!(keyEntry instanceof KeyStore.PrivateKeyEntry)) {
                Logger.warn(methodTag, PRIVATE_KEY_NOT_FOUND);
                throw new ClientException("invalid_key_private_key_missing");
            }
            Signature signature = Signature.getInstance(alg.toString());
            signature.initSign(keyEntry.getPrivateKey());
            signature.update(inputBytesToSign);
            return signature.sign();
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (UnrecoverableEntryException e) {
            exception = e;
            errCode = "protection_params_invalid";
        }
        catch (InvalidKeyException e) {
            exception = e;
            errCode = "invalid_key";
        }
        catch (SignatureException e) {
            exception = e;
            errCode = "failed_to_sign";
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(methodTag, clientException.getMessage(), clientException);
        throw clientException;
    }

    @Override
    public boolean verify(@NonNull SigningAlgorithm alg, @NonNull String plainText, @NonNull String signatureStr) {
        if (alg == null) {
            throw new NullPointerException("alg is marked non-null but is null");
        }
        if (plainText == null) {
            throw new NullPointerException("plainText is marked non-null but is null");
        }
        if (signatureStr == null) {
            throw new NullPointerException("signatureStr is marked non-null but is null");
        }
        return this.verify(alg, plainText.getBytes(UTF8), Base64.decode((String)signatureStr, (int)2));
    }

    @Override
    public boolean verify(@NonNull SigningAlgorithm alg, @NonNull byte[] inputBytesToVerify, @NonNull byte[] signatureBytes) {
        GeneralSecurityException exception;
        String errCode;
        if (alg == null) {
            throw new NullPointerException("alg is marked non-null but is null");
        }
        if (inputBytesToVerify == null) {
            throw new NullPointerException("inputBytesToVerify is marked non-null but is null");
        }
        if (signatureBytes == null) {
            throw new NullPointerException("signatureBytes is marked non-null but is null");
        }
        String methodTag = TAG + ":verify";
        try {
            KeyStore.PrivateKeyEntry keyEntry = this.mKeyManager.getEntry();
            if (keyEntry == null) {
                Logger.warn(methodTag, PRIVATE_KEY_NOT_FOUND);
                return false;
            }
            Signature signature = Signature.getInstance(alg.toString());
            signature.initVerify(keyEntry.getCertificate());
            signature.update(inputBytesToVerify);
            return signature.verify(signatureBytes);
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (KeyStoreException e) {
            errCode = "keystore_not_initialized";
            exception = e;
        }
        catch (UnrecoverableEntryException e) {
            errCode = "protection_params_invalid";
            exception = e;
        }
        catch (InvalidKeyException e) {
            errCode = "invalid_key";
            exception = e;
        }
        catch (SignatureException e) {
            errCode = "failed_to_sign";
            exception = e;
        }
        Logger.error(methodTag, errCode, exception);
        return false;
    }

    @Override
    public String encrypt(@NonNull IDevicePopManager.Cipher cipher, @NonNull String plaintext) throws ClientException {
        if (cipher == null) {
            throw new NullPointerException("cipher is marked non-null but is null");
        }
        if (plaintext == null) {
            throw new NullPointerException("plaintext is marked non-null but is null");
        }
        return Base64.encodeToString((byte[])this.encrypt(cipher, plaintext.getBytes(UTF8)), (int)3);
    }

    @Override
    public byte[] encrypt(@NonNull IDevicePopManager.Cipher cipher, @NonNull byte[] plaintext) throws ClientException {
        GeneralSecurityException exception;
        String errCode;
        if (cipher == null) {
            throw new NullPointerException("cipher is marked non-null but is null");
        }
        if (plaintext == null) {
            throw new NullPointerException("plaintext is marked non-null but is null");
        }
        String methodTag = TAG + ":encrypt";
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = this.mKeyManager.getEntry();
            PublicKey publicKey = privateKeyEntry.getCertificate().getPublicKey();
            Cipher input = Cipher.getInstance(cipher.toString());
            if (cipher.getParameters() != null) {
                input.init(1, (Key)publicKey, cipher.getParameters());
            } else {
                input.init(1, publicKey);
            }
            return input.doFinal(plaintext);
        }
        catch (InvalidKeyException e) {
            errCode = "invalid_key";
            exception = e;
        }
        catch (UnrecoverableEntryException e) {
            errCode = "protection_params_invalid";
            exception = e;
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (KeyStoreException e) {
            errCode = "keystore_not_initialized";
            exception = e;
        }
        catch (NoSuchPaddingException e) {
            errCode = "no_such_padding";
            exception = e;
        }
        catch (InvalidAlgorithmParameterException e) {
            errCode = "invalid_algorithm_parameter";
            exception = e;
        }
        catch (BadPaddingException e) {
            errCode = "bad_padding";
            exception = e;
        }
        catch (IllegalBlockSizeException e) {
            errCode = "invalid_block_size";
            exception = e;
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(methodTag, errCode, exception);
        throw clientException;
    }

    @Override
    public String decrypt(@NonNull IDevicePopManager.Cipher cipher, @NonNull String ciphertext) throws ClientException {
        if (cipher == null) {
            throw new NullPointerException("cipher is marked non-null but is null");
        }
        if (ciphertext == null) {
            throw new NullPointerException("ciphertext is marked non-null but is null");
        }
        return new String(this.decrypt(cipher, Base64.decode((String)ciphertext, (int)3)), UTF8);
    }

    @Override
    public byte[] decrypt(@NonNull IDevicePopManager.Cipher cipher, byte[] ciphertext) throws ClientException {
        GeneralSecurityException exception;
        String errCode;
        if (cipher == null) {
            throw new NullPointerException("cipher is marked non-null but is null");
        }
        String methodTag = TAG + ":decrypt";
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = this.mKeyManager.getEntry();
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            Cipher outputCipher = Cipher.getInstance(cipher.toString());
            if (cipher.getParameters() != null) {
                outputCipher.init(2, (Key)privateKey, cipher.getParameters());
            } else {
                outputCipher.init(2, privateKey);
            }
            return outputCipher.doFinal(ciphertext);
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (InvalidKeyException e) {
            errCode = "invalid_key";
            exception = e;
        }
        catch (UnrecoverableEntryException e) {
            errCode = "protection_params_invalid";
            exception = e;
        }
        catch (NoSuchPaddingException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (KeyStoreException e) {
            errCode = "keystore_not_initialized";
            exception = e;
        }
        catch (BadPaddingException e) {
            errCode = "bad_padding";
            exception = e;
        }
        catch (IllegalBlockSizeException e) {
            errCode = "invalid_block_size";
            exception = e;
        }
        catch (InvalidAlgorithmParameterException e) {
            errCode = "invalid_algorithm_parameter";
            exception = e;
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(methodTag, errCode, exception);
        throw clientException;
    }

    @Override
    public SecureHardwareState getSecureHardwareState() throws ClientException {
        GeneralSecurityException exception;
        String errCode;
        String methodTag = TAG + ":getSecureHardwareState";
        try {
            KeyPair rsaKeyPair = AbstractKeyStoreKeyManager.getKeyPairForEntry(this.mKeyManager.getEntry());
            return this.getSecureHardwareState(rsaKeyPair);
        }
        catch (KeyStoreException e) {
            errCode = "keystore_not_initialized";
            exception = e;
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (UnrecoverableEntryException e) {
            errCode = "protection_params_invalid";
            exception = e;
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(methodTag, errCode, exception);
        throw clientException;
    }

    protected abstract SecureHardwareState getSecureHardwareState(@NonNull KeyPair var1);

    @Override
    @NonNull
    public String getPublicKey(@NonNull IDevicePopManager.PublicKeyFormat format) throws ClientException {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        String methodTag = TAG + ":getPublicKey";
        switch (format) {
            case X_509_SubjectPublicKeyInfo_ASN_1: {
                return this.getX509SubjectPublicKeyInfo();
            }
            case JWK: {
                return this.getJwkPublicKey();
            }
        }
        String errMsg = "Unrecognized or unsupported key format: " + (Object)((Object)format);
        ClientException clientException = new ClientException("unknown_public_key_export_format", errMsg);
        Logger.error(methodTag, errMsg, clientException);
        throw clientException;
    }

    @Override
    public Certificate[] getCertificateChain() throws ClientException {
        return this.mKeyManager.getCertificateChain();
    }

    @NonNull
    private String getJwkPublicKey() throws ClientException {
        String errCode;
        GeneralSecurityException exception;
        String methodTag = TAG + ":getJwkPublicKey";
        try {
            Map<String, Object> jwkMap = this.getDevicePopJwkMinifiedJson();
            return GSON.toJson(jwkMap.get("jwk"), MAP_STRING_STRING_TYPE);
        }
        catch (UnrecoverableEntryException e) {
            exception = e;
            errCode = "protection_params_invalid";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(methodTag, clientException.getMessage(), clientException);
        throw clientException;
    }

    private String getX509SubjectPublicKeyInfo() throws ClientException {
        String errCode;
        GeneralSecurityException exception;
        String methodTag = TAG + ":getX509SubjectPublicKeyInfo";
        try {
            KeyStore.PrivateKeyEntry keyEntry = this.mKeyManager.getEntry();
            KeyPair rsaKeyPair = AbstractKeyStoreKeyManager.getKeyPairForEntry(keyEntry);
            PublicKey publicKey = rsaKeyPair.getPublic();
            byte[] publicKeybytes = publicKey.getEncoded();
            byte[] bytesBase64Encoded = Base64.encode((byte[])publicKeybytes, (int)0);
            return new String(bytesBase64Encoded, AuthenticationConstants.CHARSET_UTF8);
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (UnrecoverableEntryException e) {
            exception = e;
            errCode = "protection_params_invalid";
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(methodTag, clientException.getMessage(), clientException);
        throw clientException;
    }

    @Override
    public String mintSignedAccessToken(@Nullable String httpMethod, long timestamp, @NonNull URL requestUrl, @NonNull String accessToken, @Nullable String nonce) throws ClientException {
        if (requestUrl == null) {
            throw new NullPointerException("requestUrl is marked non-null but is null");
        }
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        return this.mintSignedAccessToken(httpMethod, timestamp, requestUrl, accessToken, nonce, null);
    }

    @Override
    public String mintSignedAccessToken(@Nullable String httpMethod, long timestamp, @NonNull URL requestUrl, @NonNull String accessToken, @Nullable String nonce, @Nullable String clientClaims) throws ClientException {
        if (requestUrl == null) {
            throw new NullPointerException("requestUrl is marked non-null but is null");
        }
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        return this.mintSignedHttpRequestInternal(httpMethod, timestamp, requestUrl, accessToken, nonce, clientClaims);
    }

    @Override
    public String mintSignedHttpRequest(@Nullable String httpMethod, long timestamp, @NonNull URL requestUrl, @Nullable String nonce, @Nullable String clientClaims) throws ClientException {
        if (requestUrl == null) {
            throw new NullPointerException("requestUrl is marked non-null but is null");
        }
        return this.mintSignedHttpRequestInternal(httpMethod, timestamp, requestUrl, null, nonce, clientClaims);
    }

    private String mintSignedHttpRequestInternal(@Nullable String httpMethod, long timestamp, @NonNull URL requestUrl, @Nullable String accessToken, @Nullable String nonce, @Nullable String clientClaims) throws ClientException {
        String errCode;
        Throwable exception;
        if (requestUrl == null) {
            throw new NullPointerException("requestUrl is marked non-null but is null");
        }
        String methodTag = TAG + ":mintSignedHttpRequestInternal";
        try {
            JWTClaimsSet.Builder claimsBuilder = new JWTClaimsSet.Builder();
            if (!StringUtil.isNullOrEmpty(accessToken)) {
                claimsBuilder.claim("at", (Object)accessToken);
            }
            claimsBuilder.claim("ts", (Object)timestamp);
            claimsBuilder.claim("u", (Object)requestUrl.getAuthority());
            claimsBuilder.claim("cnf", this.getDevicePopJwkMinifiedJson());
            if (!StringUtil.isNullOrEmpty(requestUrl.getPath())) {
                claimsBuilder.claim("p", (Object)requestUrl.getPath());
            }
            if (!StringUtil.isNullOrEmpty(httpMethod)) {
                claimsBuilder.claim("m", (Object)httpMethod);
            }
            if (!StringUtil.isNullOrEmpty(nonce)) {
                claimsBuilder.claim("nonce", (Object)nonce);
            }
            if (!StringUtil.isNullOrEmpty(clientClaims)) {
                claimsBuilder.claim("client_claims", (Object)clientClaims);
            }
            JWTClaimsSet claimsSet = claimsBuilder.build();
            KeyStore.PrivateKeyEntry entry = this.mKeyManager.getEntry();
            PrivateKey privateKey = entry.getPrivateKey();
            RSASSASigner signer = new RSASSASigner(privateKey);
            SignedJWT signedJWT = new SignedJWT(new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(this.getAsymmetricKeyThumbprint()).build(), claimsSet);
            signedJWT.sign((JWSSigner)signer);
            return signedJWT.serialize();
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        catch (JOSEException e) {
            exception = e;
            errCode = "failed_to_sign_jwt";
        }
        catch (UnrecoverableEntryException e) {
            exception = e;
            errCode = "protection_params_invalid";
        }
        this.performCleanupIfMintShrFails((Exception)exception);
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(methodTag, clientException.getMessage(), clientException);
        throw clientException;
    }

    protected abstract void performCleanupIfMintShrFails(@NonNull Exception var1);

    protected static Date getNow(@NonNull Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("calendar is marked non-null but is null");
        }
        return calendar.getTime();
    }

    @Override
    public PublicKey getPublicKey() throws UnrecoverableEntryException, NoSuchAlgorithmException, KeyStoreException {
        KeyStore.PrivateKeyEntry keyEntry = this.mKeyManager.getEntry();
        return keyEntry.getCertificate().getPublicKey();
    }

    private static String getReqCnfForRsaKey(@NonNull RSAKey rsaKey) throws JOSEException, JSONException {
        if (rsaKey == null) {
            throw new NullPointerException("rsaKey is marked non-null but is null");
        }
        String thumbprintStr = AbstractKeyStoreKeyManager.getThumbprintForRsaKey(rsaKey);
        String thumbprintMinifiedJson = new JSONObject().put("kid", (Object)thumbprintStr).toString();
        return AbstractDevicePopManager.base64UrlEncode(thumbprintMinifiedJson);
    }

    private static String base64UrlEncode(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        byte[] encodeBytes = input.getBytes(UTF8);
        return Base64.encodeToString((byte[])encodeBytes, (int)11);
    }

    private Map<String, Object> getDevicePopJwkMinifiedJson() throws UnrecoverableEntryException, NoSuchAlgorithmException, KeyStoreException {
        KeyStore.PrivateKeyEntry keyEntry = this.mKeyManager.getEntry();
        KeyPair rsaKeyPair = AbstractKeyStoreKeyManager.getKeyPairForEntry(keyEntry);
        RSAKey rsaKey = AbstractKeyStoreKeyManager.getRsaKeyForKeyPair(rsaKeyPair);
        RSAKey publicRsaKey = rsaKey.toPublicJWK();
        Map jwkContents = publicRsaKey.toJSONObject();
        HashMap<String, Object> wrappedJwk = new HashMap<String, Object>();
        wrappedJwk.put("jwk", jwkContents);
        return wrappedJwk;
    }

    protected static final class KeyPairGeneratorAlgorithms {
        public static final String RSA = "RSA";

        protected KeyPairGeneratorAlgorithms() {
        }
    }

    private static final class SignedHttpRequestJwtClaims {
        private static final String ACCESS_TOKEN = "at";
        private static final String TIMESTAMP = "ts";
        private static final String HTTP_METHOD = "m";
        private static final String HTTP_HOST = "u";
        private static final String HTTP_PATH = "p";
        private static final String CNF = "cnf";
        private static final String NONCE = "nonce";
        private static final String CLIENT_CLAIMS = "client_claims";
        public static final String JWK = "jwk";

        private SignedHttpRequestJwtClaims() {
        }
    }

    protected static final class CertificateProperties {
        public static final int CERTIFICATE_VALIDITY_YEARS = 99;
        public static final BigInteger SERIAL_NUMBER = BigInteger.ONE;
        public static final String COMMON_NAME = "CN=device-pop";
        public static final String ORGANIZATION_UNIT = "Identity";
        public static final String ORGANIZATION_NAME = "Microsoft Corporation";
        public static final String COUNTRY = "US";

        protected CertificateProperties() {
        }
    }
}

