/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.net;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import lombok.NonNull;

public class SSLSocketFactoryWrapper
extends SSLSocketFactory {
    private static final String TAG = SSLSocketFactoryWrapper.class.getSimpleName();
    public static final List<String> SUPPORTED_SSL_PROTOCOLS = Collections.unmodifiableList(Arrays.asList("SSLv2Hello", "SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2", "TLSv1.3"));
    private static String sLastHandshakeTLSversion = "";
    private static final String TLS_AES_128_GCM_SHA256 = "TLS_AES_128_GCM_SHA256";
    private static final String TLS_AES_256_GCM_SHA384 = "TLS_AES_256_GCM_SHA384";
    private static final String TLS_CHACHA20_POLY1305_SHA256 = "TLS_CHACHA20_POLY1305_SHA256";
    private final List<String> mEnabledSSLProtocol;
    private final SSLSocketFactory mBaseSocketFactory;

    static void setLastHandshakeTLSversion(@Nullable String lastHandshakeTLSversion) {
        sLastHandshakeTLSversion = lastHandshakeTLSversion;
    }

    static synchronized String getLastHandshakeTLSversion() {
        return sLastHandshakeTLSversion;
    }

    public SSLSocketFactoryWrapper(@NonNull SSLSocketFactory baseSocketFactory, @Nullable List<String> enabledSSLProtocol) {
        if (baseSocketFactory == null) {
            throw new NullPointerException("baseSocketFactory is marked non-null but is null");
        }
        this.mBaseSocketFactory = baseSocketFactory;
        this.mEnabledSSLProtocol = enabledSSLProtocol == null ? SUPPORTED_SSL_PROTOCOLS : enabledSSLProtocol;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.mBaseSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.mBaseSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.modifyEnabledSockets(this.mBaseSocketFactory.createSocket(s, host, port, autoClose));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.modifyEnabledSockets(this.mBaseSocketFactory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.modifyEnabledSockets(this.mBaseSocketFactory.createSocket(host, port, localHost, localPort));
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.modifyEnabledSockets(this.mBaseSocketFactory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.modifyEnabledSockets(this.mBaseSocketFactory.createSocket(address, port, localAddress, localPort));
    }

    private Socket modifyEnabledSockets(Socket socket) {
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            sslSocket.setEnabledProtocols(this.getEnabledProtocols(sslSocket));
            sslSocket.setEnabledCipherSuites(this.getEnabledCipherSuites(sslSocket));
            sslSocket.addHandshakeCompletedListener(new HandshakeCompletedListener(){

                @Override
                public void handshakeCompleted(HandshakeCompletedEvent event) {
                    SSLSocketFactoryWrapper.setLastHandshakeTLSversion(event.getSession().getProtocol());
                }
            });
        }
        return socket;
    }

    private String[] getEnabledProtocols(@NonNull SSLSocket sslSocket) {
        if (sslSocket == null) {
            throw new NullPointerException("sslSocket is marked non-null but is null");
        }
        ArrayList<String> enabledProtocols = new ArrayList<String>();
        List<String> supportedProtocols = Arrays.asList(sslSocket.getSupportedProtocols());
        for (String protocol : this.mEnabledSSLProtocol) {
            if (!supportedProtocols.contains(protocol)) continue;
            enabledProtocols.add(protocol);
        }
        String[] array = new String[enabledProtocols.size()];
        enabledProtocols.toArray(array);
        return array;
    }

    private String[] getEnabledCipherSuites(@NonNull SSLSocket sslSocket) {
        if (sslSocket == null) {
            throw new NullPointerException("sslSocket is marked non-null but is null");
        }
        ArrayList<String> enabledCipherSuites = new ArrayList<String>();
        Collections.addAll(enabledCipherSuites, sslSocket.getEnabledCipherSuites());
        List<String> supportedCipherSuites = Arrays.asList(sslSocket.getSupportedCipherSuites());
        if (supportedCipherSuites.contains(TLS_AES_128_GCM_SHA256)) {
            enabledCipherSuites.add(TLS_AES_128_GCM_SHA256);
        }
        if (supportedCipherSuites.contains(TLS_AES_256_GCM_SHA384)) {
            enabledCipherSuites.add(TLS_AES_256_GCM_SHA384);
        }
        if (supportedCipherSuites.contains(TLS_CHACHA20_POLY1305_SHA256)) {
            enabledCipherSuites.add(TLS_CHACHA20_POLY1305_SHA256);
        }
        String[] array = new String[enabledCipherSuites.size()];
        enabledCipherSuites.toArray(array);
        return array;
    }
}

