/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.net;

import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import net.jcip.annotations.Immutable;

@Immutable
public class HttpResponse {
    private final int mStatusCode;
    private final String mResponseBody;
    private final Map<String, List<String>> mResponseHeaders;
    private final Date mDate;

    public HttpResponse(int statusCode, String responseBody, Map<String, List<String>> responseHeaders) {
        this(new Date(), statusCode, responseBody, responseHeaders);
    }

    public HttpResponse(@NonNull Date date, int statusCode, String responseBody, Map<String, List<String>> headerFields) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        this.mDate = new Date(date.getTime());
        this.mStatusCode = statusCode;
        this.mResponseBody = responseBody;
        this.mResponseHeaders = headerFields;
    }

    public Date getDate() {
        return new Date(this.mDate.getTime());
    }

    public int getStatusCode() {
        return this.mStatusCode;
    }

    public String getBody() {
        return this.mResponseBody;
    }

    public Map<String, List<String>> getHeaders() {
        return this.mResponseHeaders;
    }

    public String toString() {
        return "HttpResponse{mStatusCode=" + this.mStatusCode + ", mResponseBody='" + this.mResponseBody + '\'' + ", mResponseHeaders=" + this.mResponseHeaders + '}';
    }
}

