/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.cache;

import com.microsoft.identity.common.java.cache.AbstractAccountCredentialCache;
import com.microsoft.identity.common.java.cache.ICacheKeyValueDelegate;
import com.microsoft.identity.common.java.dto.AccessTokenRecord;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.dto.Credential;
import com.microsoft.identity.common.java.dto.CredentialType;
import com.microsoft.identity.common.java.dto.IAccountRecord;
import com.microsoft.identity.common.java.dto.IdTokenRecord;
import com.microsoft.identity.common.java.dto.RefreshTokenRecord;
import com.microsoft.identity.common.java.interfaces.INameValueStorage;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.ported.Predicate;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;

public class SharedPreferencesAccountCredentialCache
extends AbstractAccountCredentialCache {
    private static final String TAG = SharedPreferencesAccountCredentialCache.class.getSimpleName();
    public static final String DEFAULT_ACCOUNT_CREDENTIAL_SHARED_PREFERENCES = "com.microsoft.identity.client.account_credential_cache";
    public static final String BROKER_FOCI_ACCOUNT_CREDENTIAL_SHARED_PREFERENCES = "com.microsoft.identity.client.account_credential_cache.foci-1";
    private static final AccountRecord EMPTY_ACCOUNT = new AccountRecord();
    private static final AccessTokenRecord EMPTY_AT = new AccessTokenRecord();
    private static final RefreshTokenRecord EMPTY_RT = new RefreshTokenRecord();
    private static final IdTokenRecord EMPTY_ID = new IdTokenRecord();
    private static final String DESERIALIZATION_FAILED = "Deserialization failed. Skipping ";
    private static final String ACCOUNT_RECORD_DESERIALIZATION_FAILED = "Deserialization failed. Skipping " + AccountRecord.class.getSimpleName();
    private static final String CREDENTIAL_DESERIALIZATION_FAILED = "Deserialization failed. Skipping " + Credential.class.getSimpleName();
    private final INameValueStorage<String> mSharedPreferencesFileManager;
    private final ICacheKeyValueDelegate mCacheValueDelegate;

    public static String getBrokerUidSequesteredFilename(int uid) {
        return "com.microsoft.identity.client.account_credential_cache.uid-" + uid;
    }

    public SharedPreferencesAccountCredentialCache(@NonNull ICacheKeyValueDelegate accountCacheValueDelegate, @NonNull INameValueStorage<String> sharedPreferencesFileManager) {
        if (accountCacheValueDelegate == null) {
            throw new NullPointerException("accountCacheValueDelegate is marked non-null but is null");
        }
        if (sharedPreferencesFileManager == null) {
            throw new NullPointerException("sharedPreferencesFileManager is marked non-null but is null");
        }
        Logger.verbose(TAG, "Init: " + TAG);
        this.mSharedPreferencesFileManager = sharedPreferencesFileManager;
        this.mCacheValueDelegate = accountCacheValueDelegate;
    }

    @Override
    public synchronized void saveAccount(@NonNull AccountRecord accountToSave) {
        if (accountToSave == null) {
            throw new NullPointerException("accountToSave is marked non-null but is null");
        }
        Logger.verbose(TAG, "Saving Account...");
        Logger.verbose(TAG, "Account type: [" + accountToSave.getClass().getSimpleName() + "]");
        String cacheKey = this.mCacheValueDelegate.generateCacheKey(accountToSave);
        Logger.verbosePII(TAG, "Generated cache key: [" + cacheKey + "]");
        AccountRecord existingAccount = this.getAccount(cacheKey);
        if (null != existingAccount) {
            accountToSave.mergeAdditionalFields(existingAccount);
        }
        String cacheValue = this.mCacheValueDelegate.generateCacheValue(accountToSave);
        this.mSharedPreferencesFileManager.put(cacheKey, cacheValue);
    }

    @Override
    public synchronized void saveCredential(@NonNull Credential credentialToSave) {
        if (credentialToSave == null) {
            throw new NullPointerException("credentialToSave is marked non-null but is null");
        }
        Logger.verbose(TAG, "Saving credential...");
        String cacheKey = this.mCacheValueDelegate.generateCacheKey(credentialToSave);
        Logger.verbosePII(TAG, "Generated cache key: [" + cacheKey + "]");
        Credential existingCredential = this.getCredential(cacheKey);
        if (null != existingCredential) {
            credentialToSave.mergeAdditionalFields(existingCredential);
        }
        String cacheValue = this.mCacheValueDelegate.generateCacheValue(credentialToSave);
        this.mSharedPreferencesFileManager.put(cacheKey, cacheValue);
    }

    @Override
    public synchronized AccountRecord getAccount(@NonNull String cacheKey) {
        if (cacheKey == null) {
            throw new NullPointerException("cacheKey is marked non-null but is null");
        }
        Logger.verbose(TAG, "Loading Account by key...");
        AccountRecord account = (AccountRecord)this.mCacheValueDelegate.fromCacheValue(this.mSharedPreferencesFileManager.get(cacheKey), AccountRecord.class);
        if (null == account) {
            Logger.warn(TAG, ACCOUNT_RECORD_DESERIALIZATION_FAILED);
        } else if (EMPTY_ACCOUNT.equals(account)) {
            Logger.warn(TAG, "The returned Account was uninitialized. Removing...");
            this.mSharedPreferencesFileManager.remove(cacheKey);
            account = null;
        }
        return account;
    }

    @Override
    @Nullable
    public synchronized Credential getCredential(@NonNull String cacheKey) {
        if (cacheKey == null) {
            throw new NullPointerException("cacheKey is marked non-null but is null");
        }
        Logger.verbose(TAG, "getCredential()");
        Logger.verbosePII(TAG, "Using cache key: [" + cacheKey + "]");
        CredentialType type = SharedPreferencesAccountCredentialCache.getCredentialTypeForCredentialCacheKey(cacheKey);
        Class<? extends Credential> clazz = null;
        if (null != type) {
            clazz = this.getTargetClassForCredentialType(cacheKey, type);
        }
        Credential credential = null;
        if (null != clazz) {
            credential = (Credential)this.mCacheValueDelegate.fromCacheValue(this.mSharedPreferencesFileManager.get(cacheKey), clazz);
        }
        if (null == credential) {
            Logger.warn(TAG, CREDENTIAL_DESERIALIZATION_FAILED);
        } else if (AccessTokenRecord.class == clazz && EMPTY_AT.equals(credential) || RefreshTokenRecord.class == clazz && EMPTY_RT.equals(credential) || IdTokenRecord.class == clazz && EMPTY_ID.equals(credential)) {
            Logger.warn(TAG, "The returned Credential was uninitialized. Removing...");
            this.mSharedPreferencesFileManager.remove(cacheKey);
            credential = null;
        }
        return credential;
    }

    @NonNull
    private Map<String, AccountRecord> getAccountsWithKeys() {
        Logger.verbose(TAG, "Loading Accounts + keys...");
        Iterator<Map.Entry<String, String>> cacheValues = this.mSharedPreferencesFileManager.getAllFilteredByKey(new Predicate<String>(){

            @Override
            public boolean test(String value) {
                return SharedPreferencesAccountCredentialCache.isAccount(value);
            }
        });
        HashMap<String, AccountRecord> accounts = new HashMap<String, AccountRecord>();
        if (cacheValues != null) {
            while (cacheValues.hasNext()) {
                Map.Entry<String, String> cacheValue = cacheValues.next();
                String cacheKey = cacheValue.getKey();
                AccountRecord account = (AccountRecord)this.mCacheValueDelegate.fromCacheValue(cacheValue.getValue().toString(), AccountRecord.class);
                if (null == account) {
                    Logger.warn(TAG, ACCOUNT_RECORD_DESERIALIZATION_FAILED);
                    continue;
                }
                accounts.put(cacheKey, account);
            }
        }
        Logger.verbose(TAG, "Returning [" + accounts.size() + "] Accounts w/ keys...");
        return accounts;
    }

    @Override
    @NonNull
    public synchronized List<AccountRecord> getAccounts() {
        Logger.verbose(TAG, "Loading Accounts...(no arg)");
        Map<String, AccountRecord> allAccounts = this.getAccountsWithKeys();
        ArrayList<AccountRecord> accounts = new ArrayList<AccountRecord>(allAccounts.values());
        Logger.info(TAG, "Found [" + accounts.size() + "] Accounts...");
        return accounts;
    }

    @Override
    @NonNull
    public List<AccountRecord> getAccountsFilteredBy(@Nullable String homeAccountId, @Nullable String environment, @Nullable String realm) {
        Logger.verbose(TAG, "Loading Accounts...");
        List<AccountRecord> allAccounts = this.getAccounts();
        List<AccountRecord> matchingAccounts = this.getAccountsFilteredByInternal(homeAccountId, environment, realm, allAccounts);
        Logger.verbose(TAG, "Found [" + matchingAccounts.size() + "] matching Accounts...");
        return matchingAccounts;
    }

    @NonNull
    private Map<String, Credential> getCredentialsWithKeys() {
        Logger.verbose(TAG, "Loading Credentials with keys...");
        HashMap<String, Credential> credentials = new HashMap<String, Credential>();
        Iterator<Map.Entry<String, String>> cacheValues = this.mSharedPreferencesFileManager.getAllFilteredByKey(new Predicate<String>(){

            @Override
            public boolean test(String value) {
                return SharedPreferencesAccountCredentialCache.isCredential(value);
            }
        });
        while (cacheValues.hasNext()) {
            Map.Entry<String, String> cacheValue = cacheValues.next();
            String cacheKey = cacheValue.getKey();
            Credential credential = (Credential)this.mCacheValueDelegate.fromCacheValue(cacheValue.getValue().toString(), this.credentialClassForType(cacheKey));
            if (null == credential) {
                Logger.warn(TAG, CREDENTIAL_DESERIALIZATION_FAILED);
                continue;
            }
            credentials.put(cacheKey, credential);
        }
        Logger.verbose(TAG, "Loaded [" + credentials.size() + "] Credentials...");
        return credentials;
    }

    @Override
    @NonNull
    public synchronized List<Credential> getCredentials() {
        Logger.verbose(TAG, "Loading Credentials...");
        Map<String, Credential> allCredentials = this.getCredentialsWithKeys();
        ArrayList<Credential> creds = new ArrayList<Credential>(allCredentials.values());
        return creds;
    }

    @Override
    @NonNull
    public List<Credential> getCredentialsFilteredBy(@Nullable String homeAccountId, @Nullable String environment, @Nullable CredentialType credentialType, @Nullable String clientId, @Nullable String realm, @Nullable String target, @Nullable String authScheme) {
        Logger.verbose(TAG, "getCredentialsFilteredBy()");
        List<Credential> allCredentials = this.getCredentials();
        List<Credential> matchingCredentials = this.getCredentialsFilteredByInternal(homeAccountId, environment, credentialType, clientId, realm, target, authScheme, null, allCredentials);
        Logger.verbose(TAG, "Found [" + matchingCredentials.size() + "] matching Credentials...");
        return matchingCredentials;
    }

    @Override
    public List<Credential> getCredentialsFilteredBy(@Nullable String homeAccountId, @Nullable String environment, @Nullable CredentialType credentialType, @Nullable String clientId, @Nullable String realm, @Nullable String target, @Nullable String authScheme, @NonNull List<Credential> inputCredentials) {
        if (inputCredentials == null) {
            throw new NullPointerException("inputCredentials is marked non-null but is null");
        }
        Logger.verbose(TAG, "getCredentialsFilteredBy() -- with input list");
        List<Credential> matchingCredentials = this.getCredentialsFilteredByInternal(homeAccountId, environment, credentialType, clientId, realm, target, authScheme, null, inputCredentials);
        Logger.verbose(TAG, "Found [" + matchingCredentials.size() + "] matching Credentials...");
        return matchingCredentials;
    }

    @Override
    @NonNull
    public List<Credential> getCredentialsFilteredBy(@Nullable String homeAccountId, @Nullable String environment, @Nullable CredentialType credentialType, @Nullable String clientId, @Nullable String realm, @Nullable String target, @Nullable String authScheme, @Nullable String requestedClaims) {
        Logger.verbose(TAG, "getCredentialsFilteredBy()");
        List<Credential> allCredentials = this.getCredentials();
        List<Credential> matchingCredentials = this.getCredentialsFilteredByInternal(homeAccountId, environment, credentialType, clientId, realm, target, authScheme, requestedClaims, allCredentials);
        Logger.verbose(TAG, "Found [" + matchingCredentials.size() + "] matching Credentials...");
        return matchingCredentials;
    }

    @Override
    public List<Credential> getCredentialsFilteredBy(@Nullable String homeAccountId, @Nullable String environment, @NonNull Set<CredentialType> credentialTypes, @Nullable String clientId, @Nullable String realm, @Nullable String target, @Nullable String authScheme, @Nullable String requestedClaims) {
        if (credentialTypes == null) {
            throw new NullPointerException("credentialTypes is marked non-null but is null");
        }
        List<Credential> allCredentials = this.getCredentials();
        ArrayList<Credential> result = new ArrayList<Credential>();
        for (CredentialType type : credentialTypes) {
            result.addAll(this.getCredentialsFilteredByInternal(homeAccountId, environment, type, clientId, realm, target, authScheme, requestedClaims, allCredentials));
        }
        return result;
    }

    @Override
    public boolean removeAccount(@NonNull AccountRecord accountToRemove) {
        if (accountToRemove == null) {
            throw new NullPointerException("accountToRemove is marked non-null but is null");
        }
        Logger.info(TAG, "Removing Account...");
        if (null == accountToRemove) {
            throw new IllegalArgumentException("Param [accountToRemove] cannot be null.");
        }
        Map<String, AccountRecord> accounts = this.getAccountsWithKeys();
        boolean accountRemoved = false;
        for (Map.Entry<String, AccountRecord> entry : accounts.entrySet()) {
            Logger.verbosePII(TAG, "Inspecting: [" + entry.getKey() + "]");
            IAccountRecord currentAccount = entry.getValue();
            if (!currentAccount.equals(accountToRemove)) continue;
            this.mSharedPreferencesFileManager.remove(entry.getKey());
            accountRemoved = true;
            break;
        }
        Logger.info(TAG, "Account was removed? [" + accountRemoved + "]");
        return accountRemoved;
    }

    @Override
    public boolean removeCredential(@NonNull Credential credentialToRemove) {
        if (credentialToRemove == null) {
            throw new NullPointerException("credentialToRemove is marked non-null but is null");
        }
        Logger.info(TAG, "Removing Credential...");
        if (null == credentialToRemove) {
            throw new IllegalArgumentException("Param [credentialToRemove] cannot be null.");
        }
        Map<String, Credential> credentials = this.getCredentialsWithKeys();
        boolean credentialRemoved = false;
        for (Map.Entry<String, Credential> entry : credentials.entrySet()) {
            Logger.verbosePII(TAG, "Inspecting: [" + entry.getKey() + "]");
            Credential currentCredential = entry.getValue();
            if (!currentCredential.equals(credentialToRemove)) continue;
            this.mSharedPreferencesFileManager.remove(entry.getKey());
            credentialRemoved = true;
            break;
        }
        Logger.info(TAG, "Credential was removed? [" + credentialRemoved + "]");
        return credentialRemoved;
    }

    @Override
    public void clearAll() {
        Logger.info(TAG, "Clearing all SharedPreferences entries...");
        this.mSharedPreferencesFileManager.clear();
        Logger.info(TAG, "SharedPreferences cleared.");
    }

    @Nullable
    private Class<? extends Credential> credentialClassForType(@NonNull String cacheKey) {
        if (cacheKey == null) {
            throw new NullPointerException("cacheKey is marked non-null but is null");
        }
        Logger.verbose(TAG, "Resolving class for key/CredentialType...");
        Logger.verbosePII(TAG, "Supplied key: [" + cacheKey + "]");
        CredentialType targetType = SharedPreferencesAccountCredentialCache.getCredentialTypeForCredentialCacheKey(cacheKey);
        if (targetType == null) {
            return null;
        }
        Logger.verbose(TAG, "CredentialType matched: [" + (Object)((Object)targetType) + "]");
        return this.getTargetClassForCredentialType(cacheKey, targetType);
    }

    @Nullable
    public static CredentialType getCredentialTypeForCredentialCacheKey(@NonNull String cacheKey) {
        if (cacheKey == null) {
            throw new NullPointerException("cacheKey is marked non-null but is null");
        }
        if (StringUtil.isNullOrEmpty(cacheKey)) {
            throw new IllegalArgumentException("Param [cacheKey] cannot be null.");
        }
        Logger.verbosePII(TAG, "Evaluating cache key for CredentialType [" + cacheKey + "]");
        HashSet<String> credentialTypesLowerCase = new HashSet<String>();
        for (String credentialTypeStr : CredentialType.valueSet()) {
            credentialTypesLowerCase.add(credentialTypeStr.toLowerCase(Locale.US));
        }
        CredentialType type = null;
        for (String credentialTypeStr : credentialTypesLowerCase) {
            if (!cacheKey.contains("-" + credentialTypeStr + "-")) continue;
            Logger.verbose(TAG, "Cache key is a Credential type...");
            if (CredentialType.AccessToken.name().equalsIgnoreCase(credentialTypeStr)) {
                type = CredentialType.AccessToken;
                break;
            }
            if (CredentialType.AccessToken_With_AuthScheme.name().equalsIgnoreCase(credentialTypeStr)) {
                type = CredentialType.AccessToken_With_AuthScheme;
                break;
            }
            if (CredentialType.RefreshToken.name().equalsIgnoreCase(credentialTypeStr)) {
                type = CredentialType.RefreshToken;
                break;
            }
            if (CredentialType.IdToken.name().equalsIgnoreCase(credentialTypeStr)) {
                type = CredentialType.IdToken;
                break;
            }
            if (CredentialType.V1IdToken.name().equalsIgnoreCase(credentialTypeStr)) {
                type = CredentialType.V1IdToken;
                break;
            }
            if (CredentialType.PrimaryRefreshToken.name().equalsIgnoreCase(credentialTypeStr)) {
                type = CredentialType.PrimaryRefreshToken;
                break;
            }
            Logger.warn(TAG, "Unexpected credential type.");
        }
        Logger.verbose(TAG, "Cache key was type: [" + type + "]");
        return type;
    }

    private static boolean isAccount(@NonNull String cacheKey) {
        if (cacheKey == null) {
            throw new NullPointerException("cacheKey is marked non-null but is null");
        }
        Logger.verbosePII(TAG, "Evaluating cache key: [" + cacheKey + "]");
        boolean isAccount = null == SharedPreferencesAccountCredentialCache.getCredentialTypeForCredentialCacheKey(cacheKey);
        Logger.verbose(TAG, "isAccount? [" + isAccount + "]");
        return isAccount;
    }

    private static boolean isCredential(@NonNull String cacheKey) {
        if (cacheKey == null) {
            throw new NullPointerException("cacheKey is marked non-null but is null");
        }
        Logger.verbosePII(TAG, "Evaluating cache key: [" + cacheKey + "]");
        boolean isCredential = null != SharedPreferencesAccountCredentialCache.getCredentialTypeForCredentialCacheKey(cacheKey);
        Logger.verbose(TAG, "isCredential? [" + isCredential + "]");
        return isCredential;
    }
}

