/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.cache;

import com.microsoft.identity.common.java.cache.IMultiTypeNameValueStorage;
import com.microsoft.identity.common.java.util.ported.Predicate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MapBackedPreferencesManager
implements IMultiTypeNameValueStorage {
    private final String mName;
    private final Map<String, String> mBackingStore = new HashMap<String, String>();

    @Override
    public void putString(String key, String value) {
        this.mBackingStore.put(key, value);
    }

    @Override
    public String getString(String key) {
        return this.mBackingStore.get(key);
    }

    @Override
    public void putLong(String key, long value) {
        this.mBackingStore.put(key, Long.toString(value));
    }

    @Override
    public long getLong(String key) {
        String s = this.mBackingStore.get(key);
        return s == null ? 0L : Long.parseLong(s);
    }

    @Override
    public Map<String, String> getAll() {
        return new HashMap<String, String>(this.mBackingStore);
    }

    @Override
    public Iterator<Map.Entry<String, String>> getAllFilteredByKey(Predicate<String> keyFilter) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.mBackingStore.entrySet()) {
            if (!keyFilter.test(entry.getKey())) continue;
            newMap.put(entry.getKey(), entry.getValue());
        }
        return newMap.entrySet().iterator();
    }

    @Override
    public boolean contains(String key) {
        return this.mBackingStore.containsKey(key);
    }

    @Override
    public void clear() {
        this.mBackingStore.clear();
    }

    @Override
    public void remove(String key) {
        this.mBackingStore.remove(key);
    }

    public static MapBackedPreferencesManagerBuilder builder() {
        return new MapBackedPreferencesManagerBuilder();
    }

    public MapBackedPreferencesManager(String name) {
        this.mName = name;
    }

    public static class MapBackedPreferencesManagerBuilder {
        private String name;

        MapBackedPreferencesManagerBuilder() {
        }

        public MapBackedPreferencesManagerBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MapBackedPreferencesManager build() {
            return new MapBackedPreferencesManager(this.name);
        }

        public String toString() {
            return "MapBackedPreferencesManager.MapBackedPreferencesManagerBuilder(name=" + this.name + ")";
        }
    }
}

