/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.authscheme;

import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.authscheme.BearerAuthenticationSchemeInternal;
import com.microsoft.identity.common.java.authscheme.INameable;
import com.microsoft.identity.common.java.authscheme.IPoPAuthenticationSchemeParams;
import com.microsoft.identity.common.java.authscheme.PopAuthenticationSchemeInternal;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.logging.Logger;
import edu.umd.cs.findbugs.annotations.Nullable;
import lombok.NonNull;

public class AuthenticationSchemeFactory {
    private static final String TAG = AuthenticationSchemeFactory.class.getSimpleName();

    public static AbstractAuthenticationScheme createScheme(@NonNull IPlatformComponents commonComponents, @Nullable INameable nameable) throws ClientException {
        if (commonComponents == null) {
            throw new NullPointerException("commonComponents is marked non-null but is null");
        }
        if (null == nameable) {
            return new BearerAuthenticationSchemeInternal();
        }
        switch (nameable.getName()) {
            case "Bearer": {
                Logger.verbose(TAG, "Constructing Bearer Authentication Scheme.");
                return new BearerAuthenticationSchemeInternal();
            }
            case "PoP": {
                if (nameable instanceof IPoPAuthenticationSchemeParams) {
                    Logger.verbose(TAG, "Constructing PoP Authentication Scheme.");
                    IPoPAuthenticationSchemeParams params = (IPoPAuthenticationSchemeParams)((Object)nameable);
                    return new PopAuthenticationSchemeInternal(commonComponents.getClockSkewManager(), commonComponents.getDefaultDevicePopManager(), params.getHttpMethod(), params.getUrl(), params.getNonce(), params.getClientClaims());
                }
                throw new IllegalStateException("Unrecognized parameter type.");
            }
        }
        throw new UnsupportedOperationException("Unknown or unsupported scheme: " + nameable.getName());
    }
}

