/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.oauth2;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.microsoft.identity.common.java.BaseAccount;
import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import com.microsoft.identity.common.java.commands.parameters.RopcTokenCommandParameters;
import com.microsoft.identity.common.java.dto.IAccountRecord;
import com.microsoft.identity.common.java.eststelemetry.EstsTelemetry;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.DiagnosticContext;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.net.HttpClient;
import com.microsoft.identity.common.java.net.HttpResponse;
import com.microsoft.identity.common.java.net.UrlConnectionHttpClient;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.java.platform.Device;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftTokenRequest;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectorySlice;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationErrorResponse;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationResponse;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationResult;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Configuration;
import com.microsoft.identity.common.java.providers.oauth2.AccessToken;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResponse;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResultFactory;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationStatus;
import com.microsoft.identity.common.java.providers.oauth2.IAuthorizationStrategy;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2Configuration;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2StrategyParameters;
import com.microsoft.identity.common.java.providers.oauth2.RefreshToken;
import com.microsoft.identity.common.java.providers.oauth2.TokenRequest;
import com.microsoft.identity.common.java.providers.oauth2.TokenResponse;
import com.microsoft.identity.common.java.providers.oauth2.TokenResult;
import com.microsoft.identity.common.java.telemetry.Telemetry;
import com.microsoft.identity.common.java.telemetry.events.UiShownEvent;
import com.microsoft.identity.common.java.util.CommonURIBuilder;
import com.microsoft.identity.common.java.util.IClockSkewManager;
import com.microsoft.identity.common.java.util.ObjectMapper;
import com.microsoft.identity.common.java.util.StringUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.TreeMap;
import java.util.concurrent.Future;
import lombok.NonNull;

public abstract class OAuth2Strategy<GenericAccessToken extends AccessToken, GenericAccount extends BaseAccount, GenericAuthorizationRequest extends AuthorizationRequest, GenericAuthorizationRequestBuilder extends AuthorizationRequest.Builder, GenericAuthorizationStrategy extends IAuthorizationStrategy, GenericOAuth2Configuration extends OAuth2Configuration, GenericOAuth2StrategyParameters extends OAuth2StrategyParameters, GenericAuthorizationResponse extends AuthorizationResponse, GenericRefreshToken extends RefreshToken, GenericTokenRequest extends TokenRequest, GenericTokenResponse extends TokenResponse, GenericTokenResult extends TokenResult, GenericAuthorizationResult extends AuthorizationResult> {
    private static final String TAG = OAuth2Strategy.class.getSimpleName();
    protected static final String TOKEN_REQUEST_CONTENT_TYPE = "application/x-www-form-urlencoded";
    protected static final String DEVICE_CODE_CONTENT_TYPE = "application/x-www-form-urlencoded";
    protected final HttpClient httpClient = UrlConnectionHttpClient.getDefaultInstance();
    protected final GenericOAuth2Configuration mConfig;
    protected final GenericOAuth2StrategyParameters mStrategyParameters;
    protected final IClockSkewManager mClockSkewManager;
    protected String mTokenEndpoint;
    protected String mAuthorizationEndpoint;
    private URI mIssuer;

    public OAuth2Strategy(GenericOAuth2Configuration config, GenericOAuth2StrategyParameters strategyParameters) {
        this.mConfig = config;
        this.mStrategyParameters = strategyParameters;
        if (null != ((OAuth2StrategyParameters)this.mStrategyParameters).getPlatformComponents()) {
            this.mClockSkewManager = ((OAuth2StrategyParameters)this.mStrategyParameters).getPlatformComponents().getClockSkewManager();
        } else {
            Logger.info(TAG, "No valid platform component to initialize ClockSkewManager with!");
            this.mClockSkewManager = null;
        }
    }

    public Future<AuthorizationResult> requestAuthorization(GenericAuthorizationRequest request, GenericAuthorizationStrategy authorizationStrategy) throws ClientException {
        this.validateAuthorizationRequest(request);
        Future<AuthorizationResult> authorizationFuture = authorizationStrategy.requestAuthorization(request, (OAuth2Strategy)this);
        Telemetry.emit(new UiShownEvent().putVisible("true"));
        return authorizationFuture;
    }

    public abstract AuthorizationResultFactory getAuthorizationResultFactory();

    public GenericTokenResult requestToken(GenericTokenRequest request) throws IOException, ClientException {
        String methodName = ":requestToken";
        Logger.verbose(TAG + ":requestToken", "Requesting token...");
        this.validateTokenRequest(request);
        HttpResponse response = this.performTokenRequest(request);
        GenericTokenResult result = this.getTokenResultFromHttpResponse(response);
        if (((TokenResult)result).getTokenResponse() != null) {
            ((TokenResult)result).getTokenResponse().setAuthority(this.mTokenEndpoint);
        }
        if (((TokenResult)result).getSuccess()) {
            this.validateTokenResponse(request, (GenericTokenResponse)result);
        }
        return result;
    }

    private void validateTokenResponse(GenericTokenRequest request, GenericTokenResult result) throws ClientException {
        this.validateTokenResponse(request, (GenericTokenResponse)((TokenResult)result).getSuccessResponse());
    }

    protected HttpResponse performTokenRequest(GenericTokenRequest request) throws IOException, ClientException {
        String methodName = ":performTokenRequest";
        Logger.verbose(TAG + ":performTokenRequest", "Performing token request...");
        String requestBody = this.getRequestBody(request);
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.put("client-request-id", (String)DiagnosticContext.INSTANCE.getRequestContext().get("correlation_id"));
        if (request instanceof MicrosoftTokenRequest && !StringUtil.isNullOrEmpty(((MicrosoftTokenRequest)request).getBrokerVersion())) {
            headers.put("x-client-brkrver", ((MicrosoftTokenRequest)request).getBrokerVersion());
        }
        headers.putAll(Device.getPlatformIdParameters());
        headers.put("x-client-SKU", (String)DiagnosticContext.INSTANCE.getRequestContext().get("x-client-SKU"));
        headers.put("x-client-Ver", Device.getProductVersion());
        headers.putAll(EstsTelemetry.getInstance().getTelemetryHeaders());
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        if (request instanceof MicrosoftTokenRequest) {
            MicrosoftTokenRequest microsoftTokenRequest = (MicrosoftTokenRequest)request;
            headers.put("x-app-name", microsoftTokenRequest.getClientAppName());
            headers.put("x-app-ver", microsoftTokenRequest.getClientAppVersion());
            if (microsoftTokenRequest.isPKeyAuthHeaderAllowed()) {
                headers.put("x-ms-PKeyAuth", "1.0");
            }
        }
        URL requestUrl = new URL(this.getTokenEndpoint());
        long networkStartTime = System.currentTimeMillis();
        HttpResponse response = this.httpClient.post(requestUrl, headers, requestBody.getBytes("UTF-8"));
        long networkEndTime = System.currentTimeMillis();
        long networkTime = networkEndTime - networkStartTime;
        SpanExtension.current().setAttribute(AttributeName.elapsed_time_network_acquire_at.name(), networkTime);
        if (null != response.getDate()) {
            this.recordClockSkew(response.getDate().getTime());
        }
        return response;
    }

    protected String getTokenEndpoint() {
        return this.mTokenEndpoint;
    }

    protected String getRequestBody(GenericTokenRequest request) throws UnsupportedEncodingException, ClientException {
        return ObjectMapper.serializeObjectToFormUrlEncoded(request);
    }

    private void recordClockSkew(long referenceTimeMillis) {
        if (null != this.mClockSkewManager) {
            this.mClockSkewManager.onTimestampReceived(referenceTimeMillis);
        }
    }

    protected final void setTokenEndpoint(String tokenEndpoint) throws ClientException {
        MicrosoftStsOAuth2Configuration oauth2Config;
        AzureActiveDirectorySlice slice;
        this.mTokenEndpoint = tokenEndpoint;
        if (this.mConfig != null && this.mConfig instanceof MicrosoftStsOAuth2Configuration && (slice = (oauth2Config = (MicrosoftStsOAuth2Configuration)this.mConfig).getSlice()) != null) {
            try {
                CommonURIBuilder commonUriBuilder = new CommonURIBuilder(this.mTokenEndpoint);
                if (!StringUtil.isNullOrEmpty(slice.getSlice())) {
                    commonUriBuilder.setParameter("slice", slice.getSlice());
                }
                if (!StringUtil.isNullOrEmpty(slice.getDataCenter())) {
                    commonUriBuilder.setParameter("dc", slice.getDataCenter());
                }
                this.mTokenEndpoint = commonUriBuilder.build().toString();
            }
            catch (URISyntaxException e) {
                throw new ClientException("malformed_url", e.getMessage(), e);
            }
        }
    }

    public String getAuthorityFromTokenEndpoint() {
        return this.mTokenEndpoint.toLowerCase(Locale.ROOT).replace("oauth2/v2.0/token", "");
    }

    protected final void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.mAuthorizationEndpoint = authorizationEndpoint;
    }

    public AuthorizationResult getDeviceCode(@NonNull MicrosoftStsAuthorizationRequest authorizationRequest) throws IOException {
        if (authorizationRequest == null) {
            throw new NullPointerException("authorizationRequest is marked non-null but is null");
        }
        String methodName = ":getDeviceCode";
        String requestBody = ObjectMapper.serializeObjectToFormUrlEncoded(authorizationRequest);
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.put("client-request-id", (String)DiagnosticContext.INSTANCE.getRequestContext().get("correlation_id"));
        headers.putAll(EstsTelemetry.getInstance().getTelemetryHeaders());
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        HttpResponse response = this.httpClient.post(((MicrosoftStsOAuth2Configuration)this.mConfig).getDeviceAuthorizationEndpoint(), headers, requestBody.getBytes("UTF-8"));
        if (response.getStatusCode() < 300) {
            HashMap parsedResponseBody = (HashMap)new Gson().fromJson(response.getBody(), TypeToken.getParameterized(HashMap.class, (Type[])new Type[]{String.class, String.class}).getType());
            MicrosoftStsAuthorizationResponse authorizationResponse = new MicrosoftStsAuthorizationResponse(null, authorizationRequest.getState(), parsedResponseBody);
            MicrosoftStsAuthorizationResult authorizationResult = new MicrosoftStsAuthorizationResult(AuthorizationStatus.SUCCESS, authorizationResponse);
            Logger.verbose(TAG + ":getDeviceCode", "Device Code Flow authorization successful...");
            return authorizationResult;
        }
        HashMap parsedResponseBody = (HashMap)new Gson().fromJson(response.getBody(), TypeToken.getParameterized(HashMap.class, (Type[])new Type[]{String.class, Object.class}).getType());
        MicrosoftStsAuthorizationErrorResponse authorizationErrorResponse = new MicrosoftStsAuthorizationErrorResponse((String)parsedResponseBody.get("error"), (String)parsedResponseBody.get("error_description"));
        MicrosoftStsAuthorizationResult authorizationResult = new MicrosoftStsAuthorizationResult(AuthorizationStatus.FAIL, authorizationErrorResponse);
        Logger.verbose(TAG + ":getDeviceCode", "Device Code Flow authorization failure...");
        return authorizationResult;
    }

    protected GenericOAuth2Configuration getOAuth2Configuration() {
        return this.mConfig;
    }

    protected URI getIssuer() {
        return this.mIssuer;
    }

    protected final void setIssuer(URI issuer) {
        this.mIssuer = issuer;
    }

    public abstract String getIssuerCacheIdentifier(GenericAuthorizationRequest var1) throws ClientException;

    public abstract GenericAccessToken getAccessTokenFromResponse(GenericTokenResponse var1);

    public abstract GenericRefreshToken getRefreshTokenFromResponse(GenericTokenResponse var1);

    public abstract GenericAccount createAccount(GenericTokenResponse var1);

    public abstract GenericAuthorizationRequestBuilder createAuthorizationRequestBuilder();

    public abstract GenericAuthorizationRequestBuilder createAuthorizationRequestBuilder(IAccountRecord var1);

    public abstract GenericTokenRequest createTokenRequest(GenericAuthorizationRequest var1, GenericAuthorizationResponse var2, AbstractAuthenticationScheme var3) throws ClientException;

    public abstract GenericTokenRequest createRefreshTokenRequest(AbstractAuthenticationScheme var1) throws ClientException;

    public abstract GenericTokenRequest createRopcTokenRequest(RopcTokenCommandParameters var1) throws ClientException;

    protected abstract void validateAuthorizationRequest(GenericAuthorizationRequest var1);

    protected abstract void validateTokenRequest(GenericTokenRequest var1);

    protected abstract GenericTokenResult getTokenResultFromHttpResponse(HttpResponse var1) throws ClientException;

    protected abstract void validateTokenResponse(GenericTokenRequest var1, GenericTokenResponse var2) throws ClientException;

    public boolean validateCachedResult(@NonNull AbstractAuthenticationScheme authScheme, @NonNull ICacheRecord cacheRecord) {
        if (authScheme == null) {
            throw new NullPointerException("authScheme is marked non-null but is null");
        }
        if (cacheRecord == null) {
            throw new NullPointerException("cacheRecord is marked non-null but is null");
        }
        return true;
    }
}

