/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.oauth2;

import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.util.StringUtil;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class IDToken {
    private static final String TAG = IDToken.class.getSimpleName();
    public static final String SUBJECT = "sub";
    public static final String NAME = "name";
    public static final String GIVEN_NAME = "given_name";
    public static final String FAMILY_NAME = "family_name";
    public static final String MIDDLE_NAME = "middle_name";
    public static final String NICKNAME = "nickname";
    public static final String PREFERRED_USERNAME = "preferred_username";
    public static final String PROFILE = "profile";
    public static final String PICTURE = "picture";
    public static final String WEBSITE = "website";
    public static final String EMAIL = "email";
    public static final String EMAIL_VERIFIED = "email_verified";
    public static final String GENDER = "gender";
    public static final String BIRTHDATE = "birthdate";
    public static final String ZONEINFO = "zoneinfo";
    public static final String LOCALE = "locale";
    public static final String PHONE_NUMBER = "phone_number";
    public static final String PHONE_NUMBER_VERIFIED = "phone_number_verified";
    public static final String ADDRESS = "address";
    public static final String UPDATED_AT = "updated_at";
    private final Map<String, ?> mTokenClaims;
    private final String mRawIdToken;

    public IDToken(String rawIdToken) throws ServiceException {
        if (StringUtil.isNullOrEmpty(rawIdToken)) {
            throw new IllegalArgumentException("null or empty raw idtoken");
        }
        this.mRawIdToken = rawIdToken;
        this.mTokenClaims = IDToken.parseJWT(rawIdToken);
    }

    public String getRawIDToken() {
        return this.mRawIdToken;
    }

    public Map<String, ?> getTokenClaims() {
        return this.mTokenClaims == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.mTokenClaims);
    }

    public static Map<String, ?> parseJWT(@NonNull String rawIdToken) throws ServiceException {
        if (rawIdToken == null) {
            throw new NullPointerException("rawIdToken is marked non-null but is null");
        }
        String methodName = ":getClaims(String)";
        HashMap result = new HashMap();
        try {
            JWT jwt = JWTParser.parse((String)rawIdToken);
            JWTClaimsSet claimsSet = jwt.getJWTClaimsSet();
            result.putAll(claimsSet.getClaims());
        }
        catch (ParseException e) {
            Logger.error(TAG + ":getClaims(String)", "Failed to parse IdToken", e);
            throw new ServiceException("Failed to parse JWT", "invalid_jwt", e);
        }
        return result;
    }

    public String getStringClaim(@NonNull String claimName) {
        if (claimName == null) {
            throw new NullPointerException("claimName is marked non-null but is null");
        }
        return this.mTokenClaims != null ? (String)this.mTokenClaims.get(claimName) : null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IDToken)) {
            return false;
        }
        IDToken other = (IDToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, ?> this$mTokenClaims = this.mTokenClaims;
        Map<String, ?> other$mTokenClaims = other.mTokenClaims;
        if (this$mTokenClaims == null ? other$mTokenClaims != null : !((Object)this$mTokenClaims).equals(other$mTokenClaims)) {
            return false;
        }
        String this$mRawIdToken = this.mRawIdToken;
        String other$mRawIdToken = other.mRawIdToken;
        return !(this$mRawIdToken == null ? other$mRawIdToken != null : !this$mRawIdToken.equals(other$mRawIdToken));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IDToken;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, ?> $mTokenClaims = this.mTokenClaims;
        result = result * 59 + ($mTokenClaims == null ? 43 : ((Object)$mTokenClaims).hashCode());
        String $mRawIdToken = this.mRawIdToken;
        result = result * 59 + ($mRawIdToken == null ? 43 : $mRawIdToken.hashCode());
        return result;
    }
}

