/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.microsoft;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.providers.oauth2.TokenResponse;
import com.microsoft.identity.common.java.util.CopyUtil;
import com.microsoft.identity.common.java.util.SchemaUtil;
import java.util.Date;

public class MicrosoftTokenResponse
extends TokenResponse {
    private static final String SESSION_KEY_JWE = "session_key_jwe";
    private static final String CLIENT_INFO = "client_info";
    private static final String EXT_EXPIRES_IN = "ext_expires_in";
    private static final String FAMILY_ID = "foci";
    private static final String REFRESH_TOKEN_EXPIRES_IN = "refresh_token_expires_in";
    private Date mExtExpiresOn;
    @SerializedName(value="refresh_token_expires_in")
    private String mRefreshTokenExpiresIn;
    @SerializedName(value="session_key_jwe")
    private String mSessionKeyJwe;
    @SerializedName(value="client_info")
    private String mClientInfo;
    private transient String mClientId;
    @Expose
    @SerializedName(value="ext_expires_in")
    private Long mExtendedExpiresIn;
    @Expose
    @SerializedName(value="foci")
    private String mFamilyId;
    @Expose
    @SerializedName(value="cloud_instance_host_name")
    private String mCloudInstanceHostName;
    private String mAuthority;
    @Expose
    private String mSpeRing;
    @Expose
    private String mRefreshTokenAge;
    private String mCliTelemErrorCode;
    private String mCliTelemSubErrorCode;

    public String getRefreshTokenExpiresIn() {
        return this.mRefreshTokenExpiresIn;
    }

    public void setRefreshTokenExpiresIn(String mRefreshTokenExpiresIn) {
        this.mRefreshTokenExpiresIn = mRefreshTokenExpiresIn;
    }

    public String getSessionKeyJwe() {
        return this.mSessionKeyJwe;
    }

    public void setSessionKeyJwe(String sessionKeyJwe) {
        this.mSessionKeyJwe = sessionKeyJwe;
    }

    @Override
    public String getAuthority() {
        return this.mAuthority;
    }

    @Override
    public void setAuthority(String authority) {
        this.mAuthority = authority;
    }

    public String getSpeRing() {
        return this.mSpeRing;
    }

    public void setSpeRing(String speRing) {
        this.mSpeRing = speRing;
    }

    public String getRefreshTokenAge() {
        return this.mRefreshTokenAge;
    }

    public void setRefreshTokenAge(String refreshTokenAge) {
        this.mRefreshTokenAge = refreshTokenAge;
    }

    public String getCliTelemErrorCode() {
        return this.mCliTelemErrorCode;
    }

    public void setCliTelemErrorCode(String serverErrorCode) {
        this.mCliTelemErrorCode = serverErrorCode;
    }

    public String getCliTelemSubErrorCode() {
        return this.mCliTelemSubErrorCode;
    }

    public void setCliTelemSubErrorCode(String serverSubErrorCode) {
        this.mCliTelemSubErrorCode = serverSubErrorCode;
    }

    public Long getExtExpiresIn() {
        return this.mExtendedExpiresIn;
    }

    public void setExtExpiresIn(Long extExpiresIn) {
        this.mExtendedExpiresIn = extExpiresIn;
    }

    public String getClientInfo() {
        return this.mClientInfo;
    }

    public void setClientInfo(String clientInfo) {
        this.mClientInfo = clientInfo;
    }

    public Date getExtExpiresOn() {
        return CopyUtil.copyIfNotNull(this.mExtExpiresOn);
    }

    public void setExtExpiresOn(Date extExpiresOn) {
        this.mExtExpiresOn = CopyUtil.copyIfNotNull(extExpiresOn);
    }

    public String getFamilyId() {
        return this.mFamilyId;
    }

    public void setFamilyId(String familyId) {
        this.mFamilyId = familyId;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public void setClientId(String clientId) {
        this.mClientId = clientId;
    }

    public String getCloudInstanceHostName() {
        return this.mCloudInstanceHostName;
    }

    public void setCloudInstanceHostName(String cloudInstanceHostName) {
        this.mCloudInstanceHostName = cloudInstanceHostName;
    }

    public String getTenantId() {
        return SchemaUtil.getTenantId(this.getClientInfo(), this.getIdToken());
    }

    public boolean isMsaAccount() {
        return "9188040d-6c67-4c5b-b112-36a304b66dad".equalsIgnoreCase(this.getTenantId());
    }

    @Override
    public String toString() {
        return "MicrosoftTokenResponse{mExtExpiresOn=" + this.mExtExpiresOn + ", mClientInfo='" + this.mClientInfo + '\'' + ", mClientId='" + this.mClientId + '\'' + ", mExtendedExpiresIn=" + this.mExtendedExpiresIn + ", mFamilyId='" + this.mFamilyId + '\'' + "} " + super.toString();
    }
}

