/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.opentelemetry;

import com.microsoft.identity.common.java.crypto.ICryptoFactory;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.exception.IErrorInformation;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.CryptoObjectName;
import com.microsoft.identity.common.java.opentelemetry.ICryptoOperation;
import com.microsoft.identity.common.java.opentelemetry.OTelUtility;
import com.microsoft.identity.common.java.util.ThrowableUtil;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongCounter;
import lombok.NonNull;

public class CryptoFactoryTelemetryHelper {
    private static final LongCounter sFailedCryptoOperationCount = OTelUtility.createLongCounter("failed_crypto_operation_count", "Number of failed crypto operations");

    public static <T> T performCryptoOperationAndUploadTelemetry(@NonNull CryptoObjectName operationName, @NonNull String algorithmName, @NonNull ICryptoFactory cryptoFactory, @NonNull ICryptoOperation<T> cryptoOperation) throws ClientException {
        if (operationName == null) {
            throw new NullPointerException("operationName is marked non-null but is null");
        }
        if (algorithmName == null) {
            throw new NullPointerException("algorithmName is marked non-null but is null");
        }
        if (cryptoFactory == null) {
            throw new NullPointerException("cryptoFactory is marked non-null but is null");
        }
        if (cryptoOperation == null) {
            throw new NullPointerException("cryptoOperation is marked non-null but is null");
        }
        try {
            return cryptoOperation.perform();
        }
        catch (Exception e) {
            Attributes attributes = Attributes.of((AttributeKey)AttributeKey.stringKey((String)AttributeName.crypto_controller.name()), (Object)cryptoFactory.getTelemetryClassName().name(), (AttributeKey)AttributeKey.stringKey((String)AttributeName.crypto_operation.name()), (Object)CryptoFactoryTelemetryHelper.getCryptoOperationEventName(operationName, algorithmName), (AttributeKey)AttributeKey.stringKey((String)AttributeName.error_type.name()), (Object)e.getClass().getSimpleName(), (AttributeKey)AttributeKey.stringKey((String)AttributeName.error_code.name()), (Object)(e instanceof IErrorInformation ? ((IErrorInformation)((Object)e)).getErrorCode() : "N/A"), (AttributeKey)AttributeKey.stringKey((String)AttributeName.crypto_exception_stack_trace.name()), (Object)ThrowableUtil.getStackTraceAsString(e));
            sFailedCryptoOperationCount.add(1L, attributes);
            throw e;
        }
    }

    private static String getCryptoOperationEventName(@NonNull CryptoObjectName operationName, @NonNull String algorithm) {
        if (operationName == null) {
            throw new NullPointerException("operationName is marked non-null but is null");
        }
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        return operationName.name() + "_" + algorithm;
    }
}

