/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.logging;

import com.microsoft.identity.common.java.logging.DiagnosticContext;
import com.microsoft.identity.common.java.logging.ILoggerCallback;
import com.microsoft.identity.common.java.logging.IRequestContext;
import com.microsoft.identity.common.java.nativeauth.util.ILoggable;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.ThrowableUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.NonNull;

public class Logger {
    private static final Object $LOCK = new Object[0];
    private static final ExecutorService sLogExecutor = Executors.newSingleThreadExecutor();
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String UNSET = "UNSET";
    private static LogLevel sLogLevel = LogLevel.VERBOSE;
    private static boolean sAllowPii = false;
    private static String sPlatformString = "";
    private static final ReentrantReadWriteLock sLoggersLock = new ReentrantReadWriteLock();
    private static final Map<String, ILoggerCallback> sLoggers = new HashMap<String, ILoggerCallback>();
    private static final SimpleDateFormat sDateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPlatformString(String platformString) {
        Object object = $LOCK;
        synchronized (object) {
            sPlatformString = platformString;
        }
    }

    static synchronized void resetLogger() {
        sLoggersLock.writeLock().lock();
        try {
            sLoggers.clear();
            sAllowPii = false;
            sPlatformString = "";
            sLogLevel = LogLevel.VERBOSE;
        }
        finally {
            sLoggersLock.writeLock().unlock();
        }
    }

    public static boolean setLogger(@NonNull String identifier, ILoggerCallback callback) {
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        sLoggersLock.writeLock().lock();
        try {
            if (callback == null) {
                sLoggers.remove(identifier);
                boolean bl = true;
                return bl;
            }
            if (sLoggers.containsValue(callback)) {
                boolean bl = false;
                return bl;
            }
            sLoggers.put(identifier, callback);
            boolean bl = true;
            return bl;
        }
        finally {
            sLoggersLock.writeLock().unlock();
        }
    }

    public static synchronized String getDiagnosticContextMetadata() {
        return Logger.getDiagnosticContextMetadata(null);
    }

    public static void error(String tag, String errorMessage, Throwable exception) {
        Logger.log(tag, LogLevel.ERROR, null, errorMessage, null, exception, false);
    }

    public static void error(String tag, String correlationID, String errorMessage, Throwable exception) {
        Logger.log(tag, LogLevel.ERROR, correlationID, errorMessage, null, exception, false);
    }

    public static void errorPII(String tag, String errorMessage, Throwable exception) {
        Logger.log(tag, LogLevel.ERROR, null, errorMessage, null, exception, true);
    }

    public static void errorPII(String tag, String correlationID, String errorMessage, Throwable exception) {
        Logger.log(tag, LogLevel.ERROR, correlationID, errorMessage, null, exception, true);
    }

    public static void warn(String tag, String message) {
        Logger.log(tag, LogLevel.WARN, null, message, null, null, false);
    }

    public static void warn(String tag, String correlationID, String message) {
        Logger.log(tag, LogLevel.WARN, correlationID, message, null, null, false);
    }

    public static void warnWithObject(String tag, String correlationID, String message, ILoggable object) {
        if (Logger.isAllowPii()) {
            Logger.log(tag, LogLevel.WARN, correlationID, message, object.toUnsanitizedString(), null, object.containsPii());
        } else {
            Logger.log(tag, LogLevel.WARN, correlationID, message, object.toString(), null, false);
        }
    }

    public static void warnWithObject(String tag, String message, ILoggable object) {
        if (Logger.isAllowPii()) {
            Logger.log(tag, LogLevel.WARN, null, message, object.toUnsanitizedString(), null, object.containsPii());
        } else {
            Logger.log(tag, LogLevel.WARN, null, message, object.toString(), null, false);
        }
    }

    public static void warnPII(String tag, String message) {
        Logger.log(tag, LogLevel.WARN, null, message, null, null, true);
    }

    public static void warnPII(String tag, String correlationID, String message) {
        Logger.log(tag, LogLevel.WARN, correlationID, message, null, null, true);
    }

    public static void info(String tag, String message) {
        Logger.log(tag, LogLevel.INFO, null, message, null, null, false);
    }

    public static void infoWithObject(String tag, String message, ILoggable object) {
        if (Logger.isAllowPii()) {
            Logger.log(tag, LogLevel.INFO, null, message, object.toUnsanitizedString(), null, object.containsPii());
        } else {
            Logger.log(tag, LogLevel.INFO, null, message, object.toString(), null, false);
        }
    }

    public static void infoWithObject(String tag, String message, String correlationId, ILoggable object) {
        if (Logger.isAllowPii()) {
            Logger.log(tag, LogLevel.INFO, correlationId, message, object.toUnsanitizedString(), null, object.containsPii());
        } else {
            Logger.log(tag, LogLevel.INFO, correlationId, message, object.toString(), null, false);
        }
    }

    public static void info(String tag, String correlationID, String message) {
        Logger.log(tag, LogLevel.INFO, correlationID, message, null, null, false);
    }

    public static void infoPII(String tag, String message) {
        Logger.log(tag, LogLevel.INFO, null, message, null, null, true);
    }

    public static void infoPII(String tag, String correlationID, String message) {
        Logger.log(tag, LogLevel.INFO, correlationID, message, null, null, true);
    }

    public static void verbose(String tag, String message) {
        Logger.log(tag, LogLevel.VERBOSE, null, message, null, null, false);
    }

    public static void verbose(String tag, String correlationID, String message) {
        Logger.log(tag, LogLevel.VERBOSE, correlationID, message, null, null, false);
    }

    public static void verbosePII(String tag, String message) {
        Logger.log(tag, LogLevel.VERBOSE, null, message, null, null, true);
    }

    public static void verbosePII(String tag, String correlationID, String message) {
        Logger.log(tag, LogLevel.VERBOSE, correlationID, message, null, null, true);
    }

    private static void log(final String tag, final @NonNull LogLevel logLevel, String correlationId, final String message, final @Nullable String objectToLog, final Throwable throwable, final boolean containsPII) {
        if (logLevel == null) {
            throw new NullPointerException("logLevel is marked non-null but is null");
        }
        if (sLogLevel == LogLevel.NO_LOG || logLevel.compareTo(sLogLevel) > 0 || !sAllowPii && containsPII) {
            return;
        }
        final Date now = new Date();
        final String diagnosticMetadata = Logger.getDiagnosticContextMetadata(correlationId);
        sLogExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"}, justification="If logging throws, there is nothing left to do but swallow the exception and move on.")
            public void run() {
                String dateTimeStamp = sDateTimeFormatter.format(now);
                String logMessage = Logger.formatMessage(diagnosticMetadata, sPlatformString, message, objectToLog, dateTimeStamp, throwable);
                sLoggersLock.readLock().lock();
                try {
                    for (String loggerCallbackKey : sLoggers.keySet()) {
                        try {
                            ILoggerCallback callback = (ILoggerCallback)sLoggers.get(loggerCallbackKey);
                            if (callback == null) continue;
                            callback.log(tag, logLevel, logMessage, containsPII);
                        }
                        catch (Exception exception) {}
                    }
                }
                finally {
                    sLoggersLock.readLock().unlock();
                }
            }
        });
    }

    private static String formatMessage(@Nullable String diagnosticMetadata, @Nullable String platformString, @Nullable String message, @Nullable String objectToLog, @NonNull String dateTimeStamp, @Nullable Throwable throwable) {
        if (dateTimeStamp == null) {
            throw new NullPointerException("dateTimeStamp is marked non-null but is null");
        }
        String logMessage = StringUtil.isNullOrEmpty(message) ? "" : message;
        String logObject = StringUtil.isNullOrEmpty(objectToLog) ? "" : objectToLog;
        return "[" + dateTimeStamp + (StringUtil.isNullOrEmpty(diagnosticMetadata) ? " " : " - " + diagnosticMetadata + " ") + "- " + platformString + "] " + logMessage + " " + logObject + " " + (throwable == null ? "" : '\n' + ThrowableUtil.getStackTraceAsString(throwable));
    }

    private static String getDiagnosticContextMetadata(@Nullable String correlationId) {
        IRequestContext requestContext = DiagnosticContext.INSTANCE.getRequestContext();
        String threadId = (String)requestContext.get("thread_id");
        if (StringUtil.isNullOrEmpty(threadId)) {
            threadId = UNSET;
        }
        if (StringUtil.isNullOrEmpty(correlationId) && StringUtil.isNullOrEmpty(correlationId = (String)requestContext.get("correlation_id"))) {
            correlationId = UNSET;
        }
        return String.format("%s: %s, %s: %s", "thread_id", threadId, "correlation_id", correlationId);
    }

    public static void setLogLevel(LogLevel sLogLevel) {
        Logger.sLogLevel = sLogLevel;
    }

    public static LogLevel getLogLevel() {
        return sLogLevel;
    }

    public static void setAllowPii(boolean sAllowPii) {
        Logger.sAllowPii = sAllowPii;
    }

    public static boolean isAllowPii() {
        return sAllowPii;
    }

    static {
        sDateTimeFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static enum LogLevel {
        NO_LOG,
        ERROR,
        WARN,
        INFO,
        VERBOSE,
        UNDEFINED;

    }
}

