/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.jwt;

import com.google.gson.Gson;
import com.microsoft.identity.common.java.AuthenticationConstants;
import com.microsoft.identity.common.java.jwt.JwtRequestBody;
import com.microsoft.identity.common.java.jwt.JwtRequestHeader;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.util.StringUtil;
import lombok.NonNull;

public final class JwtUtils {
    private static final String TAG = JwtUtils.class.getSimpleName();

    public static String generateJWT(@NonNull JwtRequestHeader header, @NonNull JwtRequestBody body) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        String methodTag = TAG + ":generateJWT";
        Logger.verbose(methodTag, "Generating JWT.");
        String headerJson = new Gson().toJson((Object)header);
        String bodyJson = new Gson().toJson((Object)body);
        String encodedJwt = StringUtil.encodeUrlSafeString(headerJson.getBytes(AuthenticationConstants.ENCODING_UTF8)) + "." + StringUtil.encodeUrlSafeString(bodyJson.getBytes(AuthenticationConstants.ENCODING_UTF8));
        return encodedJwt;
    }

    private JwtUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

