/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.crypto;

import com.microsoft.identity.common.java.AuthenticationConstants;
import com.microsoft.identity.common.java.controllers.ExceptionAdapter;
import com.microsoft.identity.common.java.crypto.CryptoSuite;
import com.microsoft.identity.common.java.crypto.IKeyAccessor;
import com.microsoft.identity.common.java.crypto.IVGenerator;
import com.microsoft.identity.common.java.crypto.SecureHardwareState;
import com.microsoft.identity.common.java.crypto.key.AbstractSecretKeyLoader;
import com.microsoft.identity.common.java.crypto.key.KeyUtil;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import cz.msebera.android.httpclient.extras.Base64;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import lombok.NonNull;

public abstract class StorageEncryptionManager
implements IKeyAccessor {
    private static final String TAG = StorageEncryptionManager.class.getSimpleName() + "#";
    public static final int IV_LENGTH = 16;
    public static final int MAC_DIGEST_LENGTH = 32;
    private static final String ENCODE_VERSION = "E1";
    public static final int KEY_IDENTIFIER_LENGTH = 4;
    private final IVGenerator mGenerator;

    public StorageEncryptionManager() {
        this.mGenerator = new IVGenerator(){
            final SecureRandom mRandom = new SecureRandom();

            @Override
            public byte[] generate() {
                byte[] iv = new byte[16];
                this.mRandom.nextBytes(iv);
                return iv;
            }
        };
    }

    StorageEncryptionManager(@NonNull IVGenerator generator) {
        if (generator == null) {
            throw new NullPointerException("generator is marked non-null but is null");
        }
        this.mGenerator = generator;
    }

    @Override
    public byte[] encrypt(byte[] plaintext) throws ClientException {
        Throwable exception;
        String errCode;
        String methodName = ":encrypt";
        AbstractSecretKeyLoader keyLoader = this.getKeyLoaderForEncryption();
        if (keyLoader == null) {
            throw new IllegalStateException("Cannot find a matching Keyloader.");
        }
        try {
            SecretKey encryptionKey = keyLoader.getKey();
            SecretKey encryptionHMACKey = KeyUtil.getHMacKey(encryptionKey);
            byte[] keyIdentifier = keyLoader.getKeyTypeIdentifier().getBytes(AuthenticationConstants.ENCODING_UTF8);
            byte[] iv = this.mGenerator.generate();
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance(keyLoader.getCipherAlgorithm());
            Mac mac = Mac.getInstance("HmacSHA256");
            cipher.init(1, (Key)encryptionKey, ivSpec);
            byte[] encrypted = cipher.doFinal(plaintext);
            mac.init(encryptionHMACKey);
            mac.update(keyIdentifier);
            mac.update(encrypted);
            mac.update(iv);
            byte[] macDigest = mac.doFinal();
            byte[] blobVerAndEncryptedDataAndIVAndMacDigest = new byte[keyIdentifier.length + encrypted.length + iv.length + macDigest.length];
            System.arraycopy(keyIdentifier, 0, blobVerAndEncryptedDataAndIVAndMacDigest, 0, keyIdentifier.length);
            System.arraycopy(encrypted, 0, blobVerAndEncryptedDataAndIVAndMacDigest, keyIdentifier.length, encrypted.length);
            System.arraycopy(iv, 0, blobVerAndEncryptedDataAndIVAndMacDigest, keyIdentifier.length + encrypted.length, iv.length);
            System.arraycopy(macDigest, 0, blobVerAndEncryptedDataAndIVAndMacDigest, keyIdentifier.length + encrypted.length + iv.length, macDigest.length);
            Logger.verbose(TAG + ":encrypt", "Finished encryption");
            return this.prefixWithEncodeVersion(blobVerAndEncryptedDataAndIVAndMacDigest);
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (NoSuchPaddingException e) {
            errCode = "no_such_padding";
            exception = e;
        }
        catch (IllegalBlockSizeException e) {
            errCode = "invalid_block_size";
            exception = e;
        }
        catch (BadPaddingException e) {
            errCode = "bad_padding";
            exception = e;
        }
        catch (InvalidKeyException e) {
            errCode = "invalid_key";
            exception = e;
        }
        catch (InvalidAlgorithmParameterException e) {
            errCode = "invalid_algorithm_parameter";
            exception = e;
        }
        catch (ClientException e) {
            throw e;
        }
        catch (Throwable e) {
            errCode = "unknown_crypto_error";
            exception = e;
        }
        throw new ClientException(errCode, exception.getMessage(), exception);
    }

    @Override
    public byte[] decrypt(byte[] cipherText) throws ClientException {
        byte[] dataBytes;
        String methodTag = TAG + ":decrypt";
        try {
            dataBytes = StorageEncryptionManager.stripEncodeVersionFromCipherText(cipherText);
        }
        catch (ClientException e) {
            Logger.verbose(methodTag, "Failed to strip encode version from cipherText, string might not be encrypted. Exception: ", e.getMessage());
            return cipherText;
        }
        List<AbstractSecretKeyLoader> keysForDecryption = this.getKeyLoaderForDecryption(cipherText);
        if (keysForDecryption.size() == 0) {
            throw new IllegalStateException("Cannot find a matching Keyloader.");
        }
        ArrayList<Throwable> suppressedException = new ArrayList<Throwable>();
        for (AbstractSecretKeyLoader keyLoader : keysForDecryption) {
            try {
                return this.decryptWithSecretKey(dataBytes, keyLoader);
            }
            catch (Throwable e) {
                Logger.warn(methodTag, "Failed to decrypt with key:" + keyLoader.getAlias() + " thumbprint : " + KeyUtil.getKeyThumbPrint(keyLoader));
                suppressedException.add(e);
            }
        }
        if (suppressedException.size() == 1) {
            throw ExceptionAdapter.clientExceptionFromException((Throwable)suppressedException.get(0));
        }
        ClientException exceptionToThrowIfAllFails = new ClientException("decryption_failed", "Tried all decryption keys and decryption still fails.");
        exceptionToThrowIfAllFails.getSuppressedException().addAll(suppressedException);
        throw exceptionToThrowIfAllFails;
    }

    @Override
    public byte[] sign(byte[] text) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean verify(byte[] text, byte[] signature) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getThumbprint() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Certificate[] getCertificateChain() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SecureHardwareState getSecureHardwareState() {
        return SecureHardwareState.FALSE;
    }

    @Override
    public IKeyAccessor generateDerivedKey(byte[] label, byte[] ctx, CryptoSuite suite) {
        throw new UnsupportedOperationException();
    }

    private byte[] decryptWithSecretKey(byte[] encryptedBlobWithoutEncodeVersion, @NonNull AbstractSecretKeyLoader keyLoader) throws ClientException {
        Throwable exception;
        String errCode;
        if (keyLoader == null) {
            throw new NullPointerException("keyLoader is marked non-null but is null");
        }
        try {
            SecretKey secretKey = keyLoader.getKey();
            SecretKey hmacKey = KeyUtil.getHMacKey(secretKey);
            int ivIndex = encryptedBlobWithoutEncodeVersion.length - 16 - 32;
            int macDigestIndex = encryptedBlobWithoutEncodeVersion.length - 32;
            int encryptedDataIndex = keyLoader.getKeyTypeIdentifier().getBytes(AuthenticationConstants.ENCODING_UTF8).length;
            int encryptedDataLength = ivIndex - encryptedDataIndex;
            Cipher cipher = Cipher.getInstance(keyLoader.getCipherAlgorithm());
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(hmacKey);
            mac.update(encryptedBlobWithoutEncodeVersion, 0, macDigestIndex);
            byte[] macDigest = mac.doFinal();
            this.assertHMac(encryptedBlobWithoutEncodeVersion, macDigestIndex, encryptedBlobWithoutEncodeVersion.length, macDigest);
            cipher.init(2, (Key)secretKey, new IvParameterSpec(encryptedBlobWithoutEncodeVersion, ivIndex, 16));
            return cipher.doFinal(encryptedBlobWithoutEncodeVersion, encryptedDataIndex, encryptedDataLength);
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (NoSuchPaddingException e) {
            errCode = "no_such_padding";
            exception = e;
        }
        catch (IllegalBlockSizeException e) {
            errCode = "invalid_block_size";
            exception = e;
        }
        catch (BadPaddingException e) {
            errCode = "bad_padding";
            exception = e;
        }
        catch (InvalidKeyException e) {
            errCode = "invalid_key";
            exception = e;
        }
        catch (InvalidAlgorithmParameterException e) {
            errCode = "invalid_algorithm_parameter";
            exception = e;
        }
        catch (IllegalArgumentException e) {
            errCode = "data_malformed";
            exception = e;
        }
        catch (ClientException e) {
            throw e;
        }
        catch (Throwable e) {
            errCode = "unknown_crypto_error";
            exception = e;
        }
        throw new ClientException(errCode, exception.getMessage(), exception);
    }

    protected static String getKeyIdentifierFromCipherText(byte[] cipherText) {
        String methodName = ":getKeyIdentifierFromCipherText";
        try {
            return new String(StorageEncryptionManager.stripEncodeVersionFromCipherText(cipherText), 0, 4, AuthenticationConstants.ENCODING_UTF8);
        }
        catch (Exception e) {
            Logger.verbose(TAG + ":getKeyIdentifierFromCipherText", e.getMessage());
            return "EXCEPTION OCCURRED GETTING KEY IDENTIFIER";
        }
    }

    private char getEncodeVersionLengthPrefix() {
        return (char)(97 + ENCODE_VERSION.length());
    }

    private static int getEncodeVersionLengthFromCipherText(@NonNull String cipherText) {
        if (cipherText == null) {
            throw new NullPointerException("cipherText is marked non-null but is null");
        }
        return cipherText.charAt(0) - 97;
    }

    private byte[] prefixWithEncodeVersion(byte[] encryptedData) {
        String encryptedText = Base64.encodeToString((byte[])encryptedData, (int)2);
        String result = this.getEncodeVersionLengthPrefix() + ENCODE_VERSION + encryptedText;
        return result.getBytes(AuthenticationConstants.ENCODING_UTF8);
    }

    private static byte[] stripEncodeVersionFromCipherText(byte[] cipherText) throws ClientException {
        if (cipherText.length < 1) {
            throw new IllegalArgumentException("Input blob is null or length < 1");
        }
        String cipherString = new String(cipherText, AuthenticationConstants.ENCODING_UTF8);
        int encodeVersionLength = StorageEncryptionManager.getEncodeVersionLengthFromCipherText(cipherString);
        StorageEncryptionManager.validateEncodeVersion(cipherString, encodeVersionLength);
        String encryptedData = cipherString.substring(1 + encodeVersionLength);
        return Base64.decode((String)encryptedData, (int)0);
    }

    private static void validateEncodeVersion(@NonNull String cipherString, int encodeVersionLength) throws ClientException {
        if (cipherString == null) {
            throw new NullPointerException("cipherString is marked non-null but is null");
        }
        if (encodeVersionLength <= 0) {
            throw new ClientException("data_malformed", String.format("Encode version length: '%s' is not valid, it must be greater of equal to 0", encodeVersionLength));
        }
        if (encodeVersionLength + 1 > cipherString.length()) {
            throw new ClientException("data_malformed", "Length of encode version string (plus the length character) is longer than the CipherString itself. The data is malformed.");
        }
        if (!cipherString.substring(1, 1 + encodeVersionLength).equals(ENCODE_VERSION)) {
            throw new ClientException("data_malformed", String.format("Unsupported encode version received. Encode version supported is: '%s'", ENCODE_VERSION));
        }
    }

    private void assertHMac(byte[] encryptedBlob, int start, int end, byte[] expected) throws ClientException {
        if (expected.length != end - start) {
            throw new ClientException("unexpected_hmac_length");
        }
        int result = 0;
        for (int i = start; i < end; ++i) {
            result = (byte)(result | expected[i - start] ^ encryptedBlob[i]);
        }
        if (result != 0) {
            throw new ClientException("hmac_mismatch");
        }
    }

    @NonNull
    public abstract AbstractSecretKeyLoader getKeyLoaderForEncryption() throws ClientException;

    @NonNull
    public abstract List<AbstractSecretKeyLoader> getKeyLoaderForDecryption(byte[] var1) throws ClientException;
}

