/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.crypto;

import com.microsoft.identity.common.java.crypto.ICryptoFactory;
import com.microsoft.identity.common.java.crypto.ISigner;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.opentelemetry.CryptoFactoryTelemetryHelper;
import com.microsoft.identity.common.java.opentelemetry.CryptoObjectName;
import com.microsoft.identity.common.java.opentelemetry.ICryptoOperation;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import lombok.NonNull;

public class BasicSigner
implements ISigner {
    private final ICryptoFactory mCryptoFactory;

    @Override
    public byte[] sign(final @NonNull PrivateKey key, final @NonNull String signingAlgorithm, final byte[] dataToBeSigned) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (signingAlgorithm == null) {
            throw new NullPointerException("signingAlgorithm is marked non-null but is null");
        }
        return CryptoFactoryTelemetryHelper.performCryptoOperationAndUploadTelemetry(CryptoObjectName.Signature, signingAlgorithm, this.mCryptoFactory, new ICryptoOperation<byte[]>(){

            @Override
            public byte[] perform() throws ClientException {
                return BasicSigner.this.signWithSignature(key, signingAlgorithm, dataToBeSigned);
            }
        });
    }

    private byte[] signWithSignature(@NonNull PrivateKey key, @NonNull String signingAlgorithm, byte[] dataToBeSigned) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (signingAlgorithm == null) {
            throw new NullPointerException("signingAlgorithm is marked non-null but is null");
        }
        try {
            Signature signer = this.mCryptoFactory.getSignature(signingAlgorithm);
            signer.initSign(key);
            signer.update(dataToBeSigned);
            return signer.sign();
        }
        catch (SignatureException e) {
            throw new ClientException("failed_to_sign", e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new ClientException("invalid_key", e.getMessage(), e);
        }
    }

    public BasicSigner(ICryptoFactory cryptoFactory) {
        this.mCryptoFactory = cryptoFactory;
    }
}

